<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffLocationServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: The OffLocationServiceType complex type defines a specific off-location service.
 * @subpackage Structs
 */
class OffLocationServiceType extends OffLocationServiceCoreType
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - documentation: Name for the contact person for the off location service.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * The TrackingID
     * Meta information extracted from the WSDL
     * - documentation: Can be used as a tracking number for delivery and collection.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $TrackingID;
    /**
     * The SpecInstructions
     * Meta information extracted from the WSDL
     * - documentation: Provides special instructions regarding the off location service (e.g., keys with receptionist). | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SpecInstructions;
    /**
     * Constructor method for OffLocationServiceType
     * @uses OffLocationServiceType::setPersonName()
     * @uses OffLocationServiceType::setTelephone()
     * @uses OffLocationServiceType::setTrackingID()
     * @uses OffLocationServiceType::setSpecInstructions()
     * @param \StructType\PersonNameType $personName
     * @param \StructType\Telephone $telephone
     * @param \StructType\UniqueID_Type $trackingID
     * @param string $specInstructions
     */
    public function __construct(\StructType\PersonNameType $personName = null, \StructType\Telephone $telephone = null, \StructType\UniqueID_Type $trackingID = null, $specInstructions = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setTrackingID($trackingID)
            ->setSpecInstructions($specInstructions);
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonNameType $personName
     * @return \StructType\OffLocationServiceType
     */
    public function setPersonName(\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\OffLocationServiceType
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get TrackingID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }
    /**
     * Set TrackingID value
     * @param \StructType\UniqueID_Type $trackingID
     * @return \StructType\OffLocationServiceType
     */
    public function setTrackingID(\StructType\UniqueID_Type $trackingID = null)
    {
        $this->TrackingID = $trackingID;
        return $this;
    }
    /**
     * Get SpecInstructions value
     * @return string|null
     */
    public function getSpecInstructions()
    {
        return $this->SpecInstructions;
    }
    /**
     * Set SpecInstructions value
     * @param string $specInstructions
     * @return \StructType\OffLocationServiceType
     */
    public function setSpecInstructions($specInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($specInstructions) && !is_string($specInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specInstructions, true), gettype($specInstructions)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($specInstructions) && mb_strlen($specInstructions) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($specInstructions)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($specInstructions) && mb_strlen($specInstructions) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($specInstructions)), __LINE__);
        }
        $this->SpecInstructions = $specInstructions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OffLocationServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
