<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffLocationServiceCoreType StructType
 * Meta information extracted from the WSDL
 * - documentation: The OffLocationServiceCoreType complex type defines the core data that is used to describe an off-location service.
 * @subpackage Structs
 */
class OffLocationServiceCoreType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * Constructor method for OffLocationServiceCoreType
     * @uses OffLocationServiceCoreType::setType()
     * @uses OffLocationServiceCoreType::setAddress()
     * @param string $type
     * @param \StructType\Address $address
     */
    public function __construct($type = null, \StructType\Address $address = null)
    {
        $this
            ->setType($type)
            ->setAddress($address);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\OffLocationServiceID_Type::valueIsValid()
     * @uses \EnumType\OffLocationServiceID_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\OffLocationServiceCoreType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OffLocationServiceID_Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OffLocationServiceID_Type', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\OffLocationServiceID_Type::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\OffLocationServiceCoreType
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OffLocationServiceCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
