<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelAvailRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Returns information about hotel properties that meet the requested criteria, indicating whether the requested service, rate, room stay, etc. is available within the date(s) specified. The response message may include Warnings from
 * business processing rules, or Errors if the request did not succeed.
 * @subpackage Structs
 */
class OTA_HotelAvailRS extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProfilesType
     */
    public $Profiles;
    /**
     * The HotelStays
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelStays
     */
    public $HotelStays;
    /**
     * The RoomStays
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RoomStays
     */
    public $RoomStays;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServicesType
     */
    public $Services;
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AreasType
     */
    public $Areas;
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Criteria
     */
    public $Criteria;
    /**
     * The CurrencyConversions
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrencyConversions
     */
    public $CurrencyConversions;
    /**
     * The SellableProducts
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SellableProducts
     */
    public $SellableProducts;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Profiles | HotelStays | RoomStays | Services | Areas | Criteria | CurrencyConversions | SellableProducts | TPA_Extensions | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The SearchCacheLevel
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SearchCacheLevel;
    /**
     * The EchoToken
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The CorrelationID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $CorrelationID;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for OTA_HotelAvailRS
     * @uses OTA_HotelAvailRS::setPOS()
     * @uses OTA_HotelAvailRS::setSuccess()
     * @uses OTA_HotelAvailRS::setWarnings()
     * @uses OTA_HotelAvailRS::setProfiles()
     * @uses OTA_HotelAvailRS::setHotelStays()
     * @uses OTA_HotelAvailRS::setRoomStays()
     * @uses OTA_HotelAvailRS::setServices()
     * @uses OTA_HotelAvailRS::setAreas()
     * @uses OTA_HotelAvailRS::setCriteria()
     * @uses OTA_HotelAvailRS::setCurrencyConversions()
     * @uses OTA_HotelAvailRS::setSellableProducts()
     * @uses OTA_HotelAvailRS::setTPA_Extensions()
     * @uses OTA_HotelAvailRS::setErrors()
     * @uses OTA_HotelAvailRS::setSearchCacheLevel()
     * @uses OTA_HotelAvailRS::setEchoToken()
     * @uses OTA_HotelAvailRS::setTimeStamp()
     * @uses OTA_HotelAvailRS::setTarget()
     * @uses OTA_HotelAvailRS::setVersion()
     * @uses OTA_HotelAvailRS::setTransactionIdentifier()
     * @uses OTA_HotelAvailRS::setSequenceNmbr()
     * @uses OTA_HotelAvailRS::setTransactionStatusCode()
     * @uses OTA_HotelAvailRS::setRetransmissionIndicator()
     * @uses OTA_HotelAvailRS::setCorrelationID()
     * @uses OTA_HotelAvailRS::setPrimaryLangID()
     * @uses OTA_HotelAvailRS::setAltLangID()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\ProfilesType $profiles
     * @param \StructType\HotelStays $hotelStays
     * @param \StructType\RoomStays $roomStays
     * @param \StructType\ServicesType $services
     * @param \StructType\AreasType $areas
     * @param \StructType\Criteria $criteria
     * @param \StructType\CurrencyConversions $currencyConversions
     * @param \StructType\SellableProducts $sellableProducts
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param \StructType\ErrorsType $errors
     * @param string $searchCacheLevel
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $correlationID
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, \StructType\ProfilesType $profiles = null, \StructType\HotelStays $hotelStays = null, \StructType\RoomStays $roomStays = null, \StructType\ServicesType $services = null, \StructType\AreasType $areas = null, \StructType\Criteria $criteria = null, \StructType\CurrencyConversions $currencyConversions = null, \StructType\SellableProducts $sellableProducts = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, \StructType\ErrorsType $errors = null, $searchCacheLevel = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $correlationID = null, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setPOS($pOS)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setProfiles($profiles)
            ->setHotelStays($hotelStays)
            ->setRoomStays($roomStays)
            ->setServices($services)
            ->setAreas($areas)
            ->setCriteria($criteria)
            ->setCurrencyConversions($currencyConversions)
            ->setSellableProducts($sellableProducts)
            ->setTPA_Extensions($tPA_Extensions)
            ->setErrors($errors)
            ->setSearchCacheLevel($searchCacheLevel)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setCorrelationID($correlationID)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuccessType $success
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarningsType $warnings
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get Profiles value
     * @return \StructType\ProfilesType|null
     */
    public function getProfiles()
    {
        return isset($this->Profiles) ? $this->Profiles : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProfiles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfiles method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProfilesForChoiceConstraintsFromSetProfiles($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Profiles can\'t be set as the property %s is already set. Only one property must be set among these properties: Profiles, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Profiles value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProfilesType $profiles
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setProfiles(\StructType\ProfilesType $profiles = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($profilesChoiceErrorMessage = self::validateProfilesForChoiceConstraintsFromSetProfiles($profiles))) {
            throw new \InvalidArgumentException($profilesChoiceErrorMessage, __LINE__);
        }
        if (is_null($profiles) || (is_array($profiles) && empty($profiles))) {
            unset($this->Profiles);
        } else {
            $this->Profiles = $profiles;
        }
        return $this;
    }
    /**
     * Get HotelStays value
     * @return \StructType\HotelStays|null
     */
    public function getHotelStays()
    {
        return isset($this->HotelStays) ? $this->HotelStays : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelStays method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelStays method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelStaysForChoiceConstraintsFromSetHotelStays($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelStays can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelStays, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelStays value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\HotelStays $hotelStays
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setHotelStays(\StructType\HotelStays $hotelStays = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($hotelStaysChoiceErrorMessage = self::validateHotelStaysForChoiceConstraintsFromSetHotelStays($hotelStays))) {
            throw new \InvalidArgumentException($hotelStaysChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelStays) || (is_array($hotelStays) && empty($hotelStays))) {
            unset($this->HotelStays);
        } else {
            $this->HotelStays = $hotelStays;
        }
        return $this;
    }
    /**
     * Get RoomStays value
     * @return \StructType\RoomStays|null
     */
    public function getRoomStays()
    {
        return isset($this->RoomStays) ? $this->RoomStays : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRoomStays method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomStays method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRoomStaysForChoiceConstraintsFromSetRoomStays($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RoomStays can\'t be set as the property %s is already set. Only one property must be set among these properties: RoomStays, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RoomStays value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoomStays $roomStays
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setRoomStays(\StructType\RoomStays $roomStays = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($roomStaysChoiceErrorMessage = self::validateRoomStaysForChoiceConstraintsFromSetRoomStays($roomStays))) {
            throw new \InvalidArgumentException($roomStaysChoiceErrorMessage, __LINE__);
        }
        if (is_null($roomStays) || (is_array($roomStays) && empty($roomStays))) {
            unset($this->RoomStays);
        } else {
            $this->RoomStays = $roomStays;
        }
        return $this;
    }
    /**
     * Get Services value
     * @return \StructType\ServicesType|null
     */
    public function getServices()
    {
        return isset($this->Services) ? $this->Services : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServices method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServicesForChoiceConstraintsFromSetServices($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Services can\'t be set as the property %s is already set. Only one property must be set among these properties: Services, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Services value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServicesType $services
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setServices(\StructType\ServicesType $services = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($servicesChoiceErrorMessage = self::validateServicesForChoiceConstraintsFromSetServices($services))) {
            throw new \InvalidArgumentException($servicesChoiceErrorMessage, __LINE__);
        }
        if (is_null($services) || (is_array($services) && empty($services))) {
            unset($this->Services);
        } else {
            $this->Services = $services;
        }
        return $this;
    }
    /**
     * Get Areas value
     * @return \StructType\AreasType|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAreas method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAreas method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAreasForChoiceConstraintsFromSetAreas($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Areas can\'t be set as the property %s is already set. Only one property must be set among these properties: Areas, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Areas value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AreasType $areas
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setAreas(\StructType\AreasType $areas = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($areasChoiceErrorMessage = self::validateAreasForChoiceConstraintsFromSetAreas($areas))) {
            throw new \InvalidArgumentException($areasChoiceErrorMessage, __LINE__);
        }
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Get Criteria value
     * @return \StructType\Criteria|null
     */
    public function getCriteria()
    {
        return isset($this->Criteria) ? $this->Criteria : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriteria method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCriteriaForChoiceConstraintsFromSetCriteria($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Criteria can\'t be set as the property %s is already set. Only one property must be set among these properties: Criteria, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Criteria value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Criteria $criteria
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setCriteria(\StructType\Criteria $criteria = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($criteriaChoiceErrorMessage = self::validateCriteriaForChoiceConstraintsFromSetCriteria($criteria))) {
            throw new \InvalidArgumentException($criteriaChoiceErrorMessage, __LINE__);
        }
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->Criteria);
        } else {
            $this->Criteria = $criteria;
        }
        return $this;
    }
    /**
     * Get CurrencyConversions value
     * @return \StructType\CurrencyConversions|null
     */
    public function getCurrencyConversions()
    {
        return isset($this->CurrencyConversions) ? $this->CurrencyConversions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCurrencyConversions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrencyConversions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCurrencyConversionsForChoiceConstraintsFromSetCurrencyConversions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'SellableProducts',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CurrencyConversions can\'t be set as the property %s is already set. Only one property must be set among these properties: CurrencyConversions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CurrencyConversions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyConversions $currencyConversions
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setCurrencyConversions(\StructType\CurrencyConversions $currencyConversions = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($currencyConversionsChoiceErrorMessage = self::validateCurrencyConversionsForChoiceConstraintsFromSetCurrencyConversions($currencyConversions))) {
            throw new \InvalidArgumentException($currencyConversionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($currencyConversions) || (is_array($currencyConversions) && empty($currencyConversions))) {
            unset($this->CurrencyConversions);
        } else {
            $this->CurrencyConversions = $currencyConversions;
        }
        return $this;
    }
    /**
     * Get SellableProducts value
     * @return \StructType\SellableProducts|null
     */
    public function getSellableProducts()
    {
        return isset($this->SellableProducts) ? $this->SellableProducts : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSellableProducts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSellableProducts method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSellableProductsForChoiceConstraintsFromSetSellableProducts($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'TPA_Extensions',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SellableProducts can\'t be set as the property %s is already set. Only one property must be set among these properties: SellableProducts, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SellableProducts value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SellableProducts $sellableProducts
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setSellableProducts(\StructType\SellableProducts $sellableProducts = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($sellableProductsChoiceErrorMessage = self::validateSellableProductsForChoiceConstraintsFromSetSellableProducts($sellableProducts))) {
            throw new \InvalidArgumentException($sellableProductsChoiceErrorMessage, __LINE__);
        }
        if (is_null($sellableProducts) || (is_array($sellableProducts) && empty($sellableProducts))) {
            unset($this->SellableProducts);
        } else {
            $this->SellableProducts = $sellableProducts;
        }
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return isset($this->TPA_Extensions) ? $this->TPA_Extensions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTPA_Extensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTPA_Extensions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TPA_Extensions can\'t be set as the property %s is already set. Only one property must be set among these properties: TPA_Extensions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TPA_Extensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($tPA_ExtensionsChoiceErrorMessage = self::validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($tPA_Extensions))) {
            throw new \InvalidArgumentException($tPA_ExtensionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($tPA_Extensions) || (is_array($tPA_Extensions) && empty($tPA_Extensions))) {
            unset($this->TPA_Extensions);
        } else {
            $this->TPA_Extensions = $tPA_Extensions;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Profiles',
            'HotelStays',
            'RoomStays',
            'Services',
            'Areas',
            'Criteria',
            'CurrencyConversions',
            'SellableProducts',
            'TPA_Extensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorsType $errors
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Success, Warnings, Profiles, HotelStays, RoomStays, Services, Areas, Criteria, CurrencyConversions, SellableProducts, TPA_Extensions, Errors)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get SearchCacheLevel value
     * @return string|null
     */
    public function getSearchCacheLevel()
    {
        return $this->SearchCacheLevel;
    }
    /**
     * Set SearchCacheLevel value
     * @param string $searchCacheLevel
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setSearchCacheLevel($searchCacheLevel = null)
    {
        // validation for constraint: string
        if (!is_null($searchCacheLevel) && !is_string($searchCacheLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchCacheLevel, true), gettype($searchCacheLevel)), __LINE__);
        }
        $this->SearchCacheLevel = $searchCacheLevel;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($echoToken) && mb_strlen($echoToken) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($echoToken)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($echoToken) && mb_strlen($echoToken) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($transactionIdentifier) && mb_strlen($transactionIdentifier) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($transactionIdentifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($transactionIdentifier) && mb_strlen($transactionIdentifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !(is_int($sequenceNmbr) || ctype_digit($sequenceNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($correlationID) && mb_strlen($correlationID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($correlationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($correlationID) && mb_strlen($correlationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\OTA_HotelAvailRS
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_HotelAvailRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
