<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Describes multimedia item(s).
 * @subpackage Structs
 */
class MultimediaDescriptionType extends AbstractStructBase
{
    /**
     * The VideoItems
     * Meta information extracted from the WSDL
     * - documentation: A collection of video items.
     * - choice: VideoItems | ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \StructType\VideoItemsType
     */
    public $VideoItems;
    /**
     * The ImageItems
     * Meta information extracted from the WSDL
     * - documentation: A collection of image items.
     * - choice: VideoItems | ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \StructType\ImageItemsType
     */
    public $ImageItems;
    /**
     * The TextItems
     * Meta information extracted from the WSDL
     * - documentation: A collection of text items.
     * - choice: VideoItems | ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \StructType\TextItemsType
     */
    public $TextItems;
    /**
     * The InfoCode
     * Meta information extracted from the WSDL
     * - documentation: Used to designate a particular type of description such as marketing. Refer to OpenTravel Code List Information Type (INF). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $InfoCode;
    /**
     * The AdditionalDetailCode
     * Meta information extracted from the WSDL
     * - documentation: Used to designate a particular type of additional information. Refer to OpenTravel Code List Additional Detail Type (ADT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $AdditionalDetailCode;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: The date and time when the multimedia information was last updated.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: The version of the content, typically in the form of "1" or "2.3."
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * Constructor method for MultimediaDescriptionType
     * @uses MultimediaDescriptionType::setVideoItems()
     * @uses MultimediaDescriptionType::setImageItems()
     * @uses MultimediaDescriptionType::setTextItems()
     * @uses MultimediaDescriptionType::setInfoCode()
     * @uses MultimediaDescriptionType::setAdditionalDetailCode()
     * @uses MultimediaDescriptionType::setLastUpdated()
     * @uses MultimediaDescriptionType::setVersion()
     * @uses MultimediaDescriptionType::setID()
     * @param \StructType\VideoItemsType $videoItems
     * @param \StructType\ImageItemsType $imageItems
     * @param \StructType\TextItemsType $textItems
     * @param string $infoCode
     * @param string $additionalDetailCode
     * @param string $lastUpdated
     * @param string $version
     * @param string $iD
     */
    public function __construct(\StructType\VideoItemsType $videoItems = null, \StructType\ImageItemsType $imageItems = null, \StructType\TextItemsType $textItems = null, $infoCode = null, $additionalDetailCode = null, $lastUpdated = null, $version = null, $iD = null)
    {
        $this
            ->setVideoItems($videoItems)
            ->setImageItems($imageItems)
            ->setTextItems($textItems)
            ->setInfoCode($infoCode)
            ->setAdditionalDetailCode($additionalDetailCode)
            ->setLastUpdated($lastUpdated)
            ->setVersion($version)
            ->setID($iD);
    }
    /**
     * Get VideoItems value
     * @return \StructType\VideoItemsType|null
     */
    public function getVideoItems()
    {
        return isset($this->VideoItems) ? $this->VideoItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVideoItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideoItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVideoItemsForChoiceConstraintsFromSetVideoItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ImageItems',
            'TextItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VideoItems can\'t be set as the property %s is already set. Only one property must be set among these properties: VideoItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VideoItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VideoItemsType $videoItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setVideoItems(\StructType\VideoItemsType $videoItems = null)
    {
        // validation for constraint: choice(VideoItems, ImageItems, TextItems)
        if ('' !== ($videoItemsChoiceErrorMessage = self::validateVideoItemsForChoiceConstraintsFromSetVideoItems($videoItems))) {
            throw new \InvalidArgumentException($videoItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($videoItems) || (is_array($videoItems) && empty($videoItems))) {
            unset($this->VideoItems);
        } else {
            $this->VideoItems = $videoItems;
        }
        return $this;
    }
    /**
     * Get ImageItems value
     * @return \StructType\ImageItemsType|null
     */
    public function getImageItems()
    {
        return isset($this->ImageItems) ? $this->ImageItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImageItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImageItemsForChoiceConstraintsFromSetImageItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'VideoItems',
            'TextItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ImageItems can\'t be set as the property %s is already set. Only one property must be set among these properties: ImageItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ImageItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ImageItemsType $imageItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setImageItems(\StructType\ImageItemsType $imageItems = null)
    {
        // validation for constraint: choice(VideoItems, ImageItems, TextItems)
        if ('' !== ($imageItemsChoiceErrorMessage = self::validateImageItemsForChoiceConstraintsFromSetImageItems($imageItems))) {
            throw new \InvalidArgumentException($imageItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($imageItems) || (is_array($imageItems) && empty($imageItems))) {
            unset($this->ImageItems);
        } else {
            $this->ImageItems = $imageItems;
        }
        return $this;
    }
    /**
     * Get TextItems value
     * @return \StructType\TextItemsType|null
     */
    public function getTextItems()
    {
        return isset($this->TextItems) ? $this->TextItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTextItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTextItemsForChoiceConstraintsFromSetTextItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'VideoItems',
            'ImageItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TextItems can\'t be set as the property %s is already set. Only one property must be set among these properties: TextItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TextItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TextItemsType $textItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setTextItems(\StructType\TextItemsType $textItems = null)
    {
        // validation for constraint: choice(VideoItems, ImageItems, TextItems)
        if ('' !== ($textItemsChoiceErrorMessage = self::validateTextItemsForChoiceConstraintsFromSetTextItems($textItems))) {
            throw new \InvalidArgumentException($textItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($textItems) || (is_array($textItems) && empty($textItems))) {
            unset($this->TextItems);
        } else {
            $this->TextItems = $textItems;
        }
        return $this;
    }
    /**
     * Get InfoCode value
     * @return string|null
     */
    public function getInfoCode()
    {
        return $this->InfoCode;
    }
    /**
     * Set InfoCode value
     * @param string $infoCode
     * @return \StructType\MultimediaDescriptionType
     */
    public function setInfoCode($infoCode = null)
    {
        // validation for constraint: string
        if (!is_null($infoCode) && !is_string($infoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoCode, true), gettype($infoCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($infoCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $infoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($infoCode, true)), __LINE__);
        }
        $this->InfoCode = $infoCode;
        return $this;
    }
    /**
     * Get AdditionalDetailCode value
     * @return string|null
     */
    public function getAdditionalDetailCode()
    {
        return $this->AdditionalDetailCode;
    }
    /**
     * Set AdditionalDetailCode value
     * @param string $additionalDetailCode
     * @return \StructType\MultimediaDescriptionType
     */
    public function setAdditionalDetailCode($additionalDetailCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDetailCode) && !is_string($additionalDetailCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDetailCode, true), gettype($additionalDetailCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($additionalDetailCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $additionalDetailCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($additionalDetailCode, true)), __LINE__);
        }
        $this->AdditionalDetailCode = $additionalDetailCode;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\MultimediaDescriptionType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\MultimediaDescriptionType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\MultimediaDescriptionType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD) && mb_strlen($iD) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultimediaDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
