<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageAcknowledgementType StructType
 * Meta information extracted from the WSDL
 * - documentation: The OTA_PayloadStdAttributes defines the standard attributes that appear on the root element for all OpenTravel Messages. | Information to acknowledge the receipt of a message.
 * @subpackage Structs
 */
class MessageAcknowledgementType extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: For all OpenTravel versioned messages, the version of the message is indicated by a decimal value.
     * - type: xs:decimal
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - documentation: Returning an empty element of this type indicates the successful processing of an OpenTravel message. This is used in conjunction with Warnings to report any warnings or business errors.
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - documentation: Used when a message has been successfully processed to report any warnings or business errors that occurred.
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - documentation: Indicates an error occurred during the processing of an OpenTravel message. If the message successfully processes, but there are business errors, those errors should be passed in the warning element.
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: May be used to return the unique id from the request message.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The EchoToken
     * Meta information extracted from the WSDL
     * - documentation: A reference for additional message identification, assigned by the requesting host system. When a request message includes an echo token the corresponding response message MUST include an echo token with an identical value. | Used
     * for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - type: StringLength1to128
     * - use: optional
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * Meta information extracted from the WSDL
     * - documentation: Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes
     * 2003-11-20T13:59:38Z).
     * - type: xs:dateTime
     * - use: optional
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to relate all messages within a transaction (e.g. this would be sent in all request and response messages that are part of an on-going transaction). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application to process messages in a certain order or to request a resynchronization of messages in the event that a system has
     * been off-line and needs to retrieve messages that were missed.
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the message is being re-sent after a failure. It is recommended that this attribute is used (i.e., set to TRUE) only when a message is retransmitted.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The CorrelationID
     * Meta information extracted from the WSDL
     * - documentation: Allow end-to-end correlation of log messages with the corresponding Web service message throughout the processing of the Web service message. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $CorrelationID;
    /**
     * The PrimaryLangID
     * Meta information extracted from the WSDL
     * - documentation: Identifes the primary language preference for the message. The human language is identified by ISO 639 codes.
     * - type: xs:language
     * - use: optional
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * Meta information extracted from the WSDL
     * - documentation: Identifies the alternate language for a customer or message. The human language is identified by ISO 639 codes.
     * - type: xs:language
     * - use: optional
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for MessageAcknowledgementType
     * @uses MessageAcknowledgementType::setVersion()
     * @uses MessageAcknowledgementType::setSuccess()
     * @uses MessageAcknowledgementType::setWarnings()
     * @uses MessageAcknowledgementType::setErrors()
     * @uses MessageAcknowledgementType::setUniqueID()
     * @uses MessageAcknowledgementType::setTPA_Extensions()
     * @uses MessageAcknowledgementType::setEchoToken()
     * @uses MessageAcknowledgementType::setTimeStamp()
     * @uses MessageAcknowledgementType::setTarget()
     * @uses MessageAcknowledgementType::setTransactionIdentifier()
     * @uses MessageAcknowledgementType::setSequenceNmbr()
     * @uses MessageAcknowledgementType::setTransactionStatusCode()
     * @uses MessageAcknowledgementType::setRetransmissionIndicator()
     * @uses MessageAcknowledgementType::setCorrelationID()
     * @uses MessageAcknowledgementType::setPrimaryLangID()
     * @uses MessageAcknowledgementType::setAltLangID()
     * @param float $version
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\ErrorsType $errors
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $correlationID
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct($version = null, \StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, \StructType\ErrorsType $errors = null, \StructType\UniqueID_Type $uniqueID = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $echoToken = null, $timeStamp = null, $target = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $correlationID = null, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setVersion($version)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setErrors($errors)
            ->setUniqueID($uniqueID)
            ->setTPA_Extensions($tPA_Extensions)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setCorrelationID($correlationID)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\MessageAcknowledgementType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuccessType $success
     * @return \StructType\MessageAcknowledgementType
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarningsType $warnings
     * @return \StructType\MessageAcknowledgementType
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorsType $errors
     * @return \StructType\MessageAcknowledgementType
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\MessageAcknowledgementType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\MessageAcknowledgementType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\MessageAcknowledgementType
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($echoToken) && mb_strlen($echoToken) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($echoToken)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($echoToken) && mb_strlen($echoToken) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\MessageAcknowledgementType
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\MessageAcknowledgementType
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\MessageAcknowledgementType
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($transactionIdentifier) && mb_strlen($transactionIdentifier) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($transactionIdentifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($transactionIdentifier) && mb_strlen($transactionIdentifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\MessageAcknowledgementType
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !(is_int($sequenceNmbr) || ctype_digit($sequenceNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\MessageAcknowledgementType
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\MessageAcknowledgementType
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\MessageAcknowledgementType
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($correlationID) && mb_strlen($correlationID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($correlationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($correlationID) && mb_strlen($correlationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\MessageAcknowledgementType
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\MessageAcknowledgementType
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageAcknowledgementType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
