<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership StructType
 * Meta information extracted from the WSDL
 * - documentation: The SelectedMembership object identifies the frequent customer reward program and (optionally) indicates points awarded for stay activity.
 * @subpackage Structs
 */
class Membership extends AbstractStructBase
{
    /**
     * The ProgramCode
     * Meta information extracted from the WSDL
     * - documentation: The code or name of the membership program ('Hertz', 'AAdvantage', etc.). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The BonusCode
     * Meta information extracted from the WSDL
     * - documentation: The code or name of the bonus program. BonusCode can be used to indicate the level of membership (Gold Club, Platinum member, etc.) | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BonusCode;
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - documentation: The account identification number for this particular member in this particular program. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AccountID;
    /**
     * The PointsEarned
     * Meta information extracted from the WSDL
     * - documentation: The total number of points earned through the selected membership.
     * - use: optional
     * @var int
     */
    public $PointsEarned;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Identifies the travel sector. Refer to OpenTravel Code List Travel Sector (TVS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * Constructor method for Membership
     * @uses Membership::setProgramCode()
     * @uses Membership::setBonusCode()
     * @uses Membership::setAccountID()
     * @uses Membership::setPointsEarned()
     * @uses Membership::setTravelSector()
     * @param string $programCode
     * @param string $bonusCode
     * @param string $accountID
     * @param int $pointsEarned
     * @param string $travelSector
     */
    public function __construct($programCode = null, $bonusCode = null, $accountID = null, $pointsEarned = null, $travelSector = null)
    {
        $this
            ->setProgramCode($programCode)
            ->setBonusCode($bonusCode)
            ->setAccountID($accountID)
            ->setPointsEarned($pointsEarned)
            ->setTravelSector($travelSector);
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \StructType\Membership
     */
    public function setProgramCode($programCode = null)
    {
        // validation for constraint: string
        if (!is_null($programCode) && !is_string($programCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programCode, true), gettype($programCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($programCode) && mb_strlen($programCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($programCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($programCode) && mb_strlen($programCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($programCode)), __LINE__);
        }
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get BonusCode value
     * @return string|null
     */
    public function getBonusCode()
    {
        return $this->BonusCode;
    }
    /**
     * Set BonusCode value
     * @param string $bonusCode
     * @return \StructType\Membership
     */
    public function setBonusCode($bonusCode = null)
    {
        // validation for constraint: string
        if (!is_null($bonusCode) && !is_string($bonusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bonusCode, true), gettype($bonusCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($bonusCode) && mb_strlen($bonusCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($bonusCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bonusCode) && mb_strlen($bonusCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bonusCode)), __LINE__);
        }
        $this->BonusCode = $bonusCode;
        return $this;
    }
    /**
     * Get AccountID value
     * @return string|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param string $accountID
     * @return \StructType\Membership
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: string
        if (!is_null($accountID) && !is_string($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($accountID) && mb_strlen($accountID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($accountID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($accountID) && mb_strlen($accountID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PointsEarned value
     * @return int|null
     */
    public function getPointsEarned()
    {
        return $this->PointsEarned;
    }
    /**
     * Set PointsEarned value
     * @param int $pointsEarned
     * @return \StructType\Membership
     */
    public function setPointsEarned($pointsEarned = null)
    {
        // validation for constraint: int
        if (!is_null($pointsEarned) && !(is_int($pointsEarned) || ctype_digit($pointsEarned))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pointsEarned, true), gettype($pointsEarned)), __LINE__);
        }
        $this->PointsEarned = $pointsEarned;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \StructType\Membership
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($travelSector) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($travelSector, true)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Membership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
