<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeetingRoomCapacityType StructType
 * Meta information extracted from the WSDL
 * - documentation: The MeetingRoomCapacity object that defines the largest room seating capacity for a meeting room at the hotel facility.
 * @subpackage Structs
 */
class MeetingRoomCapacityType extends AbstractStructBase
{
    /**
     * The Occupancy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Occupancy
     */
    public $Occupancy;
    /**
     * The MeetingRoomFormatCode
     * Meta information extracted from the WSDL
     * - documentation: The code for the format of a meeting room at the hotel facility, such as U-shape, banquet, conference style, etc. A hotel may indicate all formats that apply to the meeting room. Refer to OpenTravel Code List Meeting Room Format Code
     * (MRF). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $MeetingRoomFormatCode;
    /**
     * Constructor method for MeetingRoomCapacityType
     * @uses MeetingRoomCapacityType::setOccupancy()
     * @uses MeetingRoomCapacityType::setMeetingRoomFormatCode()
     * @param \StructType\Occupancy $occupancy
     * @param string $meetingRoomFormatCode
     */
    public function __construct(\StructType\Occupancy $occupancy = null, $meetingRoomFormatCode = null)
    {
        $this
            ->setOccupancy($occupancy)
            ->setMeetingRoomFormatCode($meetingRoomFormatCode);
    }
    /**
     * Get Occupancy value
     * @return \StructType\Occupancy|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @param \StructType\Occupancy $occupancy
     * @return \StructType\MeetingRoomCapacityType
     */
    public function setOccupancy(\StructType\Occupancy $occupancy = null)
    {
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get MeetingRoomFormatCode value
     * @return string|null
     */
    public function getMeetingRoomFormatCode()
    {
        return $this->MeetingRoomFormatCode;
    }
    /**
     * Set MeetingRoomFormatCode value
     * @param string $meetingRoomFormatCode
     * @return \StructType\MeetingRoomCapacityType
     */
    public function setMeetingRoomFormatCode($meetingRoomFormatCode = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomFormatCode) && !is_string($meetingRoomFormatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomFormatCode, true), gettype($meetingRoomFormatCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($meetingRoomFormatCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $meetingRoomFormatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($meetingRoomFormatCode, true)), __LINE__);
        }
        $this->MeetingRoomFormatCode = $meetingRoomFormatCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeetingRoomCapacityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
