<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealsIncluded StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines which meals are included with this rate program. | Defines which meals are included with this rate plan.
 * @subpackage Structs
 */
class MealsIncluded extends AbstractStructBase
{
    /**
     * The Breakfast
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates breakfast is included.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Breakfast;
    /**
     * The Lunch
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates lunch is included.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Lunch;
    /**
     * The Dinner
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates dinner is included.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Dinner;
    /**
     * The MealPlanIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, a meal plan is included in this rate plan. When false, a meal plan is not included in this rate plan.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $MealPlanIndicator;
    /**
     * The MealPlanCodes
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the types of meals included with a rate plan. Refer to OpenTravel Code List Meal Plan Type (MPT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. |
     * List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: ListOfOTA_CodeType
     * - use: optional
     * @var string[]
     */
    public $MealPlanCodes;
    /**
     * Constructor method for MealsIncluded
     * @uses MealsIncluded::setBreakfast()
     * @uses MealsIncluded::setLunch()
     * @uses MealsIncluded::setDinner()
     * @uses MealsIncluded::setMealPlanIndicator()
     * @uses MealsIncluded::setMealPlanCodes()
     * @param bool $breakfast
     * @param bool $lunch
     * @param bool $dinner
     * @param bool $mealPlanIndicator
     * @param string[] $mealPlanCodes
     */
    public function __construct($breakfast = null, $lunch = null, $dinner = null, $mealPlanIndicator = null, array $mealPlanCodes = array())
    {
        $this
            ->setBreakfast($breakfast)
            ->setLunch($lunch)
            ->setDinner($dinner)
            ->setMealPlanIndicator($mealPlanIndicator)
            ->setMealPlanCodes($mealPlanCodes);
    }
    /**
     * Get Breakfast value
     * @return bool|null
     */
    public function getBreakfast()
    {
        return $this->Breakfast;
    }
    /**
     * Set Breakfast value
     * @param bool $breakfast
     * @return \StructType\MealsIncluded
     */
    public function setBreakfast($breakfast = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakfast) && !is_bool($breakfast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($breakfast, true), gettype($breakfast)), __LINE__);
        }
        $this->Breakfast = $breakfast;
        return $this;
    }
    /**
     * Get Lunch value
     * @return bool|null
     */
    public function getLunch()
    {
        return $this->Lunch;
    }
    /**
     * Set Lunch value
     * @param bool $lunch
     * @return \StructType\MealsIncluded
     */
    public function setLunch($lunch = null)
    {
        // validation for constraint: boolean
        if (!is_null($lunch) && !is_bool($lunch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lunch, true), gettype($lunch)), __LINE__);
        }
        $this->Lunch = $lunch;
        return $this;
    }
    /**
     * Get Dinner value
     * @return bool|null
     */
    public function getDinner()
    {
        return $this->Dinner;
    }
    /**
     * Set Dinner value
     * @param bool $dinner
     * @return \StructType\MealsIncluded
     */
    public function setDinner($dinner = null)
    {
        // validation for constraint: boolean
        if (!is_null($dinner) && !is_bool($dinner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dinner, true), gettype($dinner)), __LINE__);
        }
        $this->Dinner = $dinner;
        return $this;
    }
    /**
     * Get MealPlanIndicator value
     * @return bool|null
     */
    public function getMealPlanIndicator()
    {
        return $this->MealPlanIndicator;
    }
    /**
     * Set MealPlanIndicator value
     * @param bool $mealPlanIndicator
     * @return \StructType\MealsIncluded
     */
    public function setMealPlanIndicator($mealPlanIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($mealPlanIndicator) && !is_bool($mealPlanIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mealPlanIndicator, true), gettype($mealPlanIndicator)), __LINE__);
        }
        $this->MealPlanIndicator = $mealPlanIndicator;
        return $this;
    }
    /**
     * Get MealPlanCodes value
     * @return string[]|null
     */
    public function getMealPlanCodes()
    {
        return $this->MealPlanCodes;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPlanCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPlanCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPlanCodesForArrayConstraintsFromSetMealPlanCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mealsIncludedMealPlanCodesItem) {
            // validation for constraint: itemType
            if (!is_string($mealsIncludedMealPlanCodesItem)) {
                $invalidValues[] = is_object($mealsIncludedMealPlanCodesItem) ? get_class($mealsIncludedMealPlanCodesItem) : sprintf('%s(%s)', gettype($mealsIncludedMealPlanCodesItem), var_export($mealsIncludedMealPlanCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPlanCodes property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPlanCodes value
     * @param string[] $mealPlanCodes
     * @return \StructType\MealsIncluded
     */
    public function setMealPlanCodes(array $mealPlanCodes = array())
    {
        // validation for constraint: list
        if ('' !== ($mealPlanCodesArrayErrorMessage = self::validateMealPlanCodesForArrayConstraintsFromSetMealPlanCodes($mealPlanCodes))) {
            throw new \InvalidArgumentException($mealPlanCodesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($mealPlanCodes) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $mealPlanCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($mealPlanCodes, true)), __LINE__);
        }
        $this->MealPlanCodes = is_array($mealPlanCodes) ? implode(' ', $mealPlanCodes) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealsIncluded
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
