<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MasterAccount StructType
 * Meta information extracted from the WSDL
 * - documentation: Account established at the hotel for the purposes of billing arrangements for an entity.
 * @subpackage Structs
 */
class MasterAccount extends DirectBillType
{
    /**
     * The BillingType
     * @var string
     */
    public $BillingType;
    /**
     * The SignFoodAndBev
     * Meta information extracted from the WSDL
     * - documentation: false | Food and beverage billed to master account. If false, guest pays own.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $SignFoodAndBev;
    /**
     * Constructor method for MasterAccount
     * @uses MasterAccount::setBillingType()
     * @uses MasterAccount::setSignFoodAndBev()
     * @param string $billingType
     * @param bool $signFoodAndBev
     */
    public function __construct($billingType = null, $signFoodAndBev = null)
    {
        $this
            ->setBillingType($billingType)
            ->setSignFoodAndBev($signFoodAndBev);
    }
    /**
     * Get BillingType value
     * @return string|null
     */
    public function getBillingType()
    {
        return $this->BillingType;
    }
    /**
     * Set BillingType value
     * @param string $billingType
     * @return \StructType\MasterAccount
     */
    public function setBillingType($billingType = null)
    {
        // validation for constraint: string
        if (!is_null($billingType) && !is_string($billingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingType, true), gettype($billingType)), __LINE__);
        }
        $this->BillingType = $billingType;
        return $this;
    }
    /**
     * Get SignFoodAndBev value
     * @return bool|null
     */
    public function getSignFoodAndBev()
    {
        return $this->SignFoodAndBev;
    }
    /**
     * Set SignFoodAndBev value
     * @param bool $signFoodAndBev
     * @return \StructType\MasterAccount
     */
    public function setSignFoodAndBev($signFoodAndBev = null)
    {
        // validation for constraint: boolean
        if (!is_null($signFoodAndBev) && !is_bool($signFoodAndBev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signFoodAndBev, true), gettype($signFoodAndBev)), __LINE__);
        }
        $this->SignFoodAndBev = $signFoodAndBev;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MasterAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
