<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyRedemption StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide a promotion code of the loyalty redemption. | Identifies the Loyalty scheme, programs and promotions within the scheme, membership reference, form factor used by the certificate, the number of nights it can be used
 * for and its current status. | Details of a loyalty redemption arrangement. This is normally miles or points.
 * @subpackage Structs
 */
class LoyaltyRedemption extends AbstractStructBase
{
    /**
     * The LoyaltyCertificate
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\LoyaltyCertificate[]
     */
    public $LoyaltyCertificate;
    /**
     * The RedemptionQuantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of loyalty units being redeemed.
     * - use: optional
     * @var int
     */
    public $RedemptionQuantity;
    /**
     * The CertificateNumber
     * Meta information extracted from the WSDL
     * - documentation: The loyalty redemption certificate identifier. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CertificateNumber;
    /**
     * The MemberNumber
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the member in the program. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $MemberNumber;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - documentation: This identifies the loyalty program. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $ProgramName;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Promotion code is the identifier used by the host to link directly with a specific named advertising campaign. By including the required code, the client is able to gain access to special offers which may have been created for a
     * specifically targeted group via a CRM system or for a wider advertising campaign using Television or press adverts. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: List of the vendor codes associated with a promotion. | Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: ListOfStringLength1to8
     * - use: optional
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * Constructor method for LoyaltyRedemption
     * @uses LoyaltyRedemption::setLoyaltyCertificate()
     * @uses LoyaltyRedemption::setRedemptionQuantity()
     * @uses LoyaltyRedemption::setCertificateNumber()
     * @uses LoyaltyRedemption::setMemberNumber()
     * @uses LoyaltyRedemption::setProgramName()
     * @uses LoyaltyRedemption::setPromotionCode()
     * @uses LoyaltyRedemption::setPromotionVendorCode()
     * @param \StructType\LoyaltyCertificate[] $loyaltyCertificate
     * @param int $redemptionQuantity
     * @param string $certificateNumber
     * @param string $memberNumber
     * @param string $programName
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     */
    public function __construct(array $loyaltyCertificate = array(), $redemptionQuantity = null, $certificateNumber = null, $memberNumber = null, $programName = null, $promotionCode = null, array $promotionVendorCode = array())
    {
        $this
            ->setLoyaltyCertificate($loyaltyCertificate)
            ->setRedemptionQuantity($redemptionQuantity)
            ->setCertificateNumber($certificateNumber)
            ->setMemberNumber($memberNumber)
            ->setProgramName($programName)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode);
    }
    /**
     * Get LoyaltyCertificate value
     * @return \StructType\LoyaltyCertificate[]|null
     */
    public function getLoyaltyCertificate()
    {
        return $this->LoyaltyCertificate;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyCertificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyCertificate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyCertificateForArrayConstraintsFromSetLoyaltyCertificate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyRedemptionLoyaltyCertificateItem) {
            // validation for constraint: itemType
            if (!$loyaltyRedemptionLoyaltyCertificateItem instanceof \StructType\LoyaltyCertificate) {
                $invalidValues[] = is_object($loyaltyRedemptionLoyaltyCertificateItem) ? get_class($loyaltyRedemptionLoyaltyCertificateItem) : sprintf('%s(%s)', gettype($loyaltyRedemptionLoyaltyCertificateItem), var_export($loyaltyRedemptionLoyaltyCertificateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyCertificate property can only contain items of type \StructType\LoyaltyCertificate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyCertificate[] $loyaltyCertificate
     * @return \StructType\LoyaltyRedemption
     */
    public function setLoyaltyCertificate(array $loyaltyCertificate = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyCertificateArrayErrorMessage = self::validateLoyaltyCertificateForArrayConstraintsFromSetLoyaltyCertificate($loyaltyCertificate))) {
            throw new \InvalidArgumentException($loyaltyCertificateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($loyaltyCertificate) && count($loyaltyCertificate) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($loyaltyCertificate)), __LINE__);
        }
        $this->LoyaltyCertificate = $loyaltyCertificate;
        return $this;
    }
    /**
     * Add item to LoyaltyCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyCertificate $item
     * @return \StructType\LoyaltyRedemption
     */
    public function addToLoyaltyCertificate(\StructType\LoyaltyCertificate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyCertificate) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyCertificate property can only contain items of type \StructType\LoyaltyCertificate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->LoyaltyCertificate) && count($this->LoyaltyCertificate) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->LoyaltyCertificate)), __LINE__);
        }
        $this->LoyaltyCertificate[] = $item;
        return $this;
    }
    /**
     * Get RedemptionQuantity value
     * @return int|null
     */
    public function getRedemptionQuantity()
    {
        return $this->RedemptionQuantity;
    }
    /**
     * Set RedemptionQuantity value
     * @param int $redemptionQuantity
     * @return \StructType\LoyaltyRedemption
     */
    public function setRedemptionQuantity($redemptionQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionQuantity) && !(is_int($redemptionQuantity) || ctype_digit($redemptionQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionQuantity, true), gettype($redemptionQuantity)), __LINE__);
        }
        $this->RedemptionQuantity = $redemptionQuantity;
        return $this;
    }
    /**
     * Get CertificateNumber value
     * @return string|null
     */
    public function getCertificateNumber()
    {
        return $this->CertificateNumber;
    }
    /**
     * Set CertificateNumber value
     * @param string $certificateNumber
     * @return \StructType\LoyaltyRedemption
     */
    public function setCertificateNumber($certificateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($certificateNumber) && !is_string($certificateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificateNumber, true), gettype($certificateNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($certificateNumber) && mb_strlen($certificateNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($certificateNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($certificateNumber) && mb_strlen($certificateNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($certificateNumber)), __LINE__);
        }
        $this->CertificateNumber = $certificateNumber;
        return $this;
    }
    /**
     * Get MemberNumber value
     * @return string|null
     */
    public function getMemberNumber()
    {
        return $this->MemberNumber;
    }
    /**
     * Set MemberNumber value
     * @param string $memberNumber
     * @return \StructType\LoyaltyRedemption
     */
    public function setMemberNumber($memberNumber = null)
    {
        // validation for constraint: string
        if (!is_null($memberNumber) && !is_string($memberNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberNumber, true), gettype($memberNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($memberNumber) && mb_strlen($memberNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($memberNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($memberNumber) && mb_strlen($memberNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($memberNumber)), __LINE__);
        }
        $this->MemberNumber = $memberNumber;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\LoyaltyRedemption
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($programName) && mb_strlen($programName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($programName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($programName) && mb_strlen($programName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\LoyaltyRedemption
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyRedemptionPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($loyaltyRedemptionPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($loyaltyRedemptionPromotionVendorCodeItem) ? get_class($loyaltyRedemptionPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($loyaltyRedemptionPromotionVendorCodeItem), var_export($loyaltyRedemptionPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\LoyaltyRedemption
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoyaltyRedemption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
