<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyPointsAccrualsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of SelectedLoyalty classes that are used to report earned bonuses.
 * @subpackage Structs
 */
class LoyaltyPointsAccrualsType extends AbstractStructBase
{
    /**
     * The SelectedLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\SelectedLoyalty[]
     */
    public $SelectedLoyalty;
    /**
     * Constructor method for LoyaltyPointsAccrualsType
     * @uses LoyaltyPointsAccrualsType::setSelectedLoyalty()
     * @param \StructType\SelectedLoyalty[] $selectedLoyalty
     */
    public function __construct(array $selectedLoyalty = array())
    {
        $this
            ->setSelectedLoyalty($selectedLoyalty);
    }
    /**
     * Get SelectedLoyalty value
     * @return \StructType\SelectedLoyalty[]|null
     */
    public function getSelectedLoyalty()
    {
        return $this->SelectedLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedLoyaltyForArrayConstraintsFromSetSelectedLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyPointsAccrualsTypeSelectedLoyaltyItem) {
            // validation for constraint: itemType
            if (!$loyaltyPointsAccrualsTypeSelectedLoyaltyItem instanceof \StructType\SelectedLoyalty) {
                $invalidValues[] = is_object($loyaltyPointsAccrualsTypeSelectedLoyaltyItem) ? get_class($loyaltyPointsAccrualsTypeSelectedLoyaltyItem) : sprintf('%s(%s)', gettype($loyaltyPointsAccrualsTypeSelectedLoyaltyItem), var_export($loyaltyPointsAccrualsTypeSelectedLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedLoyalty property can only contain items of type \StructType\SelectedLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedLoyalty[] $selectedLoyalty
     * @return \StructType\LoyaltyPointsAccrualsType
     */
    public function setSelectedLoyalty(array $selectedLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedLoyaltyArrayErrorMessage = self::validateSelectedLoyaltyForArrayConstraintsFromSetSelectedLoyalty($selectedLoyalty))) {
            throw new \InvalidArgumentException($selectedLoyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($selectedLoyalty) && count($selectedLoyalty) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($selectedLoyalty)), __LINE__);
        }
        $this->SelectedLoyalty = $selectedLoyalty;
        return $this;
    }
    /**
     * Add item to SelectedLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedLoyalty $item
     * @return \StructType\LoyaltyPointsAccrualsType
     */
    public function addToSelectedLoyalty(\StructType\SelectedLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedLoyalty) {
            throw new \InvalidArgumentException(sprintf('The SelectedLoyalty property can only contain items of type \StructType\SelectedLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->SelectedLoyalty) && count($this->SelectedLoyalty) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->SelectedLoyalty)), __LINE__);
        }
        $this->SelectedLoyalty[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoyaltyPointsAccrualsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
