<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyCertificate StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the loyalty scheme, programs and promotions within the scheme, membership reference, format of the certificate, the number of nights it can be used and its current status. | A certificate may be needed in order to redeem
 * miles or points. Certificates may be used in combination with each other as part of a reservation.
 * @subpackage Structs
 */
class LoyaltyCertificate extends AbstractStructBase
{
    /**
     * The ID_Context
     * Meta information extracted from the WSDL
     * - documentation: Identifies the source of the code that identifies program or promotion within a loyalty scheme. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $ID_Context;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the ExpireDate is the first day after the applicable period (e.g. when expire date is Oct 15 the last date of the period is Oct 14).
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The NmbrOfNights
     * Meta information extracted from the WSDL
     * - documentation: The number of nights of the hotel stay that are used to calculate the redemption amount.
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $NmbrOfNights;
    /**
     * The Format
     * @var string
     */
    public $Format;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Used to define the status of the certificate e.g. Available, Voided, Cancelled, Reserved, Used. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The CertificateNumber
     * Meta information extracted from the WSDL
     * - documentation: The loyalty redemption certificate identifier. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CertificateNumber;
    /**
     * The MemberNumber
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the member in the program. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $MemberNumber;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - documentation: This identifies the loyalty program. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $ProgramName;
    /**
     * Constructor method for LoyaltyCertificate
     * @uses LoyaltyCertificate::setID_Context()
     * @uses LoyaltyCertificate::setEffectiveDate()
     * @uses LoyaltyCertificate::setExpireDate()
     * @uses LoyaltyCertificate::setExpireDateExclusiveIndicator()
     * @uses LoyaltyCertificate::setNmbrOfNights()
     * @uses LoyaltyCertificate::setFormat()
     * @uses LoyaltyCertificate::setStatus()
     * @uses LoyaltyCertificate::setID()
     * @uses LoyaltyCertificate::setCertificateNumber()
     * @uses LoyaltyCertificate::setMemberNumber()
     * @uses LoyaltyCertificate::setProgramName()
     * @param string $iD_Context
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param int $nmbrOfNights
     * @param string $format
     * @param string $status
     * @param string $iD
     * @param string $certificateNumber
     * @param string $memberNumber
     * @param string $programName
     */
    public function __construct($iD_Context = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $nmbrOfNights = null, $format = null, $status = null, $iD = null, $certificateNumber = null, $memberNumber = null, $programName = null)
    {
        $this
            ->setID_Context($iD_Context)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setNmbrOfNights($nmbrOfNights)
            ->setFormat($format)
            ->setStatus($status)
            ->setID($iD)
            ->setCertificateNumber($certificateNumber)
            ->setMemberNumber($memberNumber)
            ->setProgramName($programName);
    }
    /**
     * Get ID_Context value
     * @return string|null
     */
    public function getID_Context()
    {
        return $this->ID_Context;
    }
    /**
     * Set ID_Context value
     * @param string $iD_Context
     * @return \StructType\LoyaltyCertificate
     */
    public function setID_Context($iD_Context = null)
    {
        // validation for constraint: string
        if (!is_null($iD_Context) && !is_string($iD_Context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD_Context, true), gettype($iD_Context)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD_Context) && mb_strlen($iD_Context) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD_Context)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD_Context) && mb_strlen($iD_Context) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD_Context)), __LINE__);
        }
        $this->ID_Context = $iD_Context;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\LoyaltyCertificate
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\LoyaltyCertificate
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\LoyaltyCertificate
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get NmbrOfNights value
     * @return int|null
     */
    public function getNmbrOfNights()
    {
        return $this->NmbrOfNights;
    }
    /**
     * Set NmbrOfNights value
     * @param int $nmbrOfNights
     * @return \StructType\LoyaltyCertificate
     */
    public function setNmbrOfNights($nmbrOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($nmbrOfNights) && !(is_int($nmbrOfNights) || ctype_digit($nmbrOfNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nmbrOfNights, true), gettype($nmbrOfNights)), __LINE__);
        }
        $this->NmbrOfNights = $nmbrOfNights;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\LoyaltyCertificate
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\LoyaltyCertificate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($status) && mb_strlen($status) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($status) && mb_strlen($status) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\LoyaltyCertificate
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD) && mb_strlen($iD) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CertificateNumber value
     * @return string|null
     */
    public function getCertificateNumber()
    {
        return $this->CertificateNumber;
    }
    /**
     * Set CertificateNumber value
     * @param string $certificateNumber
     * @return \StructType\LoyaltyCertificate
     */
    public function setCertificateNumber($certificateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($certificateNumber) && !is_string($certificateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificateNumber, true), gettype($certificateNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($certificateNumber) && mb_strlen($certificateNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($certificateNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($certificateNumber) && mb_strlen($certificateNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($certificateNumber)), __LINE__);
        }
        $this->CertificateNumber = $certificateNumber;
        return $this;
    }
    /**
     * Get MemberNumber value
     * @return string|null
     */
    public function getMemberNumber()
    {
        return $this->MemberNumber;
    }
    /**
     * Set MemberNumber value
     * @param string $memberNumber
     * @return \StructType\LoyaltyCertificate
     */
    public function setMemberNumber($memberNumber = null)
    {
        // validation for constraint: string
        if (!is_null($memberNumber) && !is_string($memberNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberNumber, true), gettype($memberNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($memberNumber) && mb_strlen($memberNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($memberNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($memberNumber) && mb_strlen($memberNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($memberNumber)), __LINE__);
        }
        $this->MemberNumber = $memberNumber;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\LoyaltyCertificate
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($programName) && mb_strlen($programName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($programName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($programName) && mb_strlen($programName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoyaltyCertificate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
