<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Loyalty StructType
 * @subpackage Structs
 */
class Loyalty extends AbstractStructBase
{
    /**
     * The ReservationActionType
     * Meta information extracted from the WSDL
     * - documentation: Tells the status of the reservation (e.g. stay, no-show, cancelled, etc.) | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $ReservationActionType;
    /**
     * The SelectedLoyaltyRPH
     * Meta information extracted from the WSDL
     * - documentation: The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: RPH_Type
     * - use: optional
     * @var string
     */
    public $SelectedLoyaltyRPH;
    /**
     * The ProgramCode
     * Meta information extracted from the WSDL
     * - documentation: This may be used for different loyalty awards (e.g. points and miles awarded). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The BonusCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $BonusCode;
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $AccountID;
    /**
     * The PointsEarned
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $PointsEarned;
    /**
     * Constructor method for Loyalty
     * @uses Loyalty::setReservationActionType()
     * @uses Loyalty::setSelectedLoyaltyRPH()
     * @uses Loyalty::setProgramCode()
     * @uses Loyalty::setBonusCode()
     * @uses Loyalty::setAccountID()
     * @uses Loyalty::setPointsEarned()
     * @param string $reservationActionType
     * @param string $selectedLoyaltyRPH
     * @param string $programCode
     * @param string $bonusCode
     * @param string $accountID
     * @param string $pointsEarned
     */
    public function __construct($reservationActionType = null, $selectedLoyaltyRPH = null, $programCode = null, $bonusCode = null, $accountID = null, $pointsEarned = null)
    {
        $this
            ->setReservationActionType($reservationActionType)
            ->setSelectedLoyaltyRPH($selectedLoyaltyRPH)
            ->setProgramCode($programCode)
            ->setBonusCode($bonusCode)
            ->setAccountID($accountID)
            ->setPointsEarned($pointsEarned);
    }
    /**
     * Get ReservationActionType value
     * @return string|null
     */
    public function getReservationActionType()
    {
        return $this->ReservationActionType;
    }
    /**
     * Set ReservationActionType value
     * @param string $reservationActionType
     * @return \StructType\Loyalty
     */
    public function setReservationActionType($reservationActionType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationActionType) && !is_string($reservationActionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationActionType, true), gettype($reservationActionType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($reservationActionType) && mb_strlen($reservationActionType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($reservationActionType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reservationActionType) && mb_strlen($reservationActionType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reservationActionType)), __LINE__);
        }
        $this->ReservationActionType = $reservationActionType;
        return $this;
    }
    /**
     * Get SelectedLoyaltyRPH value
     * @return string|null
     */
    public function getSelectedLoyaltyRPH()
    {
        return $this->SelectedLoyaltyRPH;
    }
    /**
     * Set SelectedLoyaltyRPH value
     * @param string $selectedLoyaltyRPH
     * @return \StructType\Loyalty
     */
    public function setSelectedLoyaltyRPH($selectedLoyaltyRPH = null)
    {
        // validation for constraint: string
        if (!is_null($selectedLoyaltyRPH) && !is_string($selectedLoyaltyRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedLoyaltyRPH, true), gettype($selectedLoyaltyRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($selectedLoyaltyRPH) && !preg_match('/[0-9]{1,8}/', $selectedLoyaltyRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($selectedLoyaltyRPH, true)), __LINE__);
        }
        $this->SelectedLoyaltyRPH = $selectedLoyaltyRPH;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \StructType\Loyalty
     */
    public function setProgramCode($programCode = null)
    {
        // validation for constraint: string
        if (!is_null($programCode) && !is_string($programCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programCode, true), gettype($programCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($programCode) && mb_strlen($programCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($programCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($programCode) && mb_strlen($programCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($programCode)), __LINE__);
        }
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get BonusCode value
     * @return string|null
     */
    public function getBonusCode()
    {
        return $this->BonusCode;
    }
    /**
     * Set BonusCode value
     * @param string $bonusCode
     * @return \StructType\Loyalty
     */
    public function setBonusCode($bonusCode = null)
    {
        // validation for constraint: string
        if (!is_null($bonusCode) && !is_string($bonusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bonusCode, true), gettype($bonusCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($bonusCode) && mb_strlen($bonusCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($bonusCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bonusCode) && mb_strlen($bonusCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bonusCode)), __LINE__);
        }
        $this->BonusCode = $bonusCode;
        return $this;
    }
    /**
     * Get AccountID value
     * @return string|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param string $accountID
     * @return \StructType\Loyalty
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: string
        if (!is_null($accountID) && !is_string($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($accountID) && mb_strlen($accountID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($accountID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($accountID) && mb_strlen($accountID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PointsEarned value
     * @return string|null
     */
    public function getPointsEarned()
    {
        return $this->PointsEarned;
    }
    /**
     * Set PointsEarned value
     * @param string $pointsEarned
     * @return \StructType\Loyalty
     */
    public function setPointsEarned($pointsEarned = null)
    {
        // validation for constraint: string
        if (!is_null($pointsEarned) && !is_string($pointsEarned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointsEarned, true), gettype($pointsEarned)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($pointsEarned) && mb_strlen($pointsEarned) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($pointsEarned)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pointsEarned) && mb_strlen($pointsEarned) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pointsEarned)), __LINE__);
        }
        $this->PointsEarned = $pointsEarned;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Loyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
