<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeywordPref StructType
 * Meta information extracted from the WSDL
 * - documentation: This element stores data about an airline marketing keyword.
 * @subpackage Structs
 */
class KeywordPref extends AbstractStructBase
{
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates to which airline the element is associated. | Used for Character Strings, length 0 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $VendorCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Text of the Keyword element. | Used for Character Strings, length 0 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - documentation: The keyword is defined by the airline. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Keyword;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Confirmation status from the airline. Refer to OpenTravel code list Status (STS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $StatusCode;
    /**
     * The NumberInParty
     * Meta information extracted from the WSDL
     * - documentation: Number of passengers that will benefit from the request.
     * - use: optional
     * @var int
     */
    public $NumberInParty;
    /**
     * The AirlineVendorRPH
     * Meta information extracted from the WSDL
     * - documentation: The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $AirlineVendorRPH;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * Constructor method for KeywordPref
     * @uses KeywordPref::setVendorCode()
     * @uses KeywordPref::setDescription()
     * @uses KeywordPref::setKeyword()
     * @uses KeywordPref::setStatusCode()
     * @uses KeywordPref::setNumberInParty()
     * @uses KeywordPref::setAirlineVendorRPH()
     * @uses KeywordPref::setTransferAction()
     * @param string $vendorCode
     * @param string $description
     * @param string $keyword
     * @param string $statusCode
     * @param int $numberInParty
     * @param string[] $airlineVendorRPH
     * @param string $transferAction
     */
    public function __construct($vendorCode = null, $description = null, $keyword = null, $statusCode = null, $numberInParty = null, array $airlineVendorRPH = array(), $transferAction = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setDescription($description)
            ->setKeyword($keyword)
            ->setStatusCode($statusCode)
            ->setNumberInParty($numberInParty)
            ->setAirlineVendorRPH($airlineVendorRPH)
            ->setTransferAction($transferAction);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\KeywordPref
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vendorCode) && mb_strlen($vendorCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vendorCode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vendorCode) && mb_strlen($vendorCode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\KeywordPref
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Keyword value
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param string $keyword
     * @return \StructType\KeywordPref
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyword, true), gettype($keyword)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($keyword) && mb_strlen($keyword) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($keyword)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($keyword) && mb_strlen($keyword) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($keyword)), __LINE__);
        }
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\KeywordPref
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($statusCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($statusCode, true)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \StructType\KeywordPref
     */
    public function setNumberInParty($numberInParty = null)
    {
        // validation for constraint: int
        if (!is_null($numberInParty) && !(is_int($numberInParty) || ctype_digit($numberInParty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberInParty, true), gettype($numberInParty)), __LINE__);
        }
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get AirlineVendorRPH value
     * @return string[]|null
     */
    public function getAirlineVendorRPH()
    {
        return $this->AirlineVendorRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineVendorRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineVendorRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineVendorRPHForArrayConstraintsFromSetAirlineVendorRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keywordPrefAirlineVendorRPHItem) {
            // validation for constraint: itemType
            if (!is_string($keywordPrefAirlineVendorRPHItem)) {
                $invalidValues[] = is_object($keywordPrefAirlineVendorRPHItem) ? get_class($keywordPrefAirlineVendorRPHItem) : sprintf('%s(%s)', gettype($keywordPrefAirlineVendorRPHItem), var_export($keywordPrefAirlineVendorRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineVendorRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineVendorRPH value
     * @param string[] $airlineVendorRPH
     * @return \StructType\KeywordPref
     */
    public function setAirlineVendorRPH(array $airlineVendorRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($airlineVendorRPHArrayErrorMessage = self::validateAirlineVendorRPHForArrayConstraintsFromSetAirlineVendorRPH($airlineVendorRPH))) {
            throw new \InvalidArgumentException($airlineVendorRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($airlineVendorRPH) && !preg_match('/[0-9]{1,8}/', $airlineVendorRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($airlineVendorRPH, true)), __LINE__);
        }
        $this->AirlineVendorRPH = is_array($airlineVendorRPH) ? implode(' ', $airlineVendorRPH) : null;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\KeywordPref
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KeywordPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
