<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvCount StructType
 * Meta information extracted from the WSDL
 * - documentation: Individual inventory count (e.g., Physical, Available, Sold, OOO, NAFS).
 * @subpackage Structs
 */
class InvCount extends AbstractStructBase
{
    /**
     * The InvBlockCutoff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvBlockCutoff
     */
    public $InvBlockCutoff;
    /**
     * The CountType
     * Meta information extracted from the WSDL
     * - documentation: This identifies the type of inventory count being reported. Refer to OpenTravel Code List Inventory Count Type (INV). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $CountType;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Count;
    /**
     * The AdjustReason
     * Meta information extracted from the WSDL
     * - documentation: Additional information as to the nature of the inventory adjustment; eg. GUEST EXTENDED STAY, or ROOM CHANGE, etc. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AdjustReason;
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ActionType;
    /**
     * Constructor method for InvCount
     * @uses InvCount::setInvBlockCutoff()
     * @uses InvCount::setCountType()
     * @uses InvCount::setCount()
     * @uses InvCount::setAdjustReason()
     * @uses InvCount::setActionType()
     * @param \StructType\InvBlockCutoff $invBlockCutoff
     * @param string $countType
     * @param int $count
     * @param string $adjustReason
     * @param string $actionType
     */
    public function __construct(\StructType\InvBlockCutoff $invBlockCutoff = null, $countType = null, $count = null, $adjustReason = null, $actionType = null)
    {
        $this
            ->setInvBlockCutoff($invBlockCutoff)
            ->setCountType($countType)
            ->setCount($count)
            ->setAdjustReason($adjustReason)
            ->setActionType($actionType);
    }
    /**
     * Get InvBlockCutoff value
     * @return \StructType\InvBlockCutoff|null
     */
    public function getInvBlockCutoff()
    {
        return $this->InvBlockCutoff;
    }
    /**
     * Set InvBlockCutoff value
     * @param \StructType\InvBlockCutoff $invBlockCutoff
     * @return \StructType\InvCount
     */
    public function setInvBlockCutoff(\StructType\InvBlockCutoff $invBlockCutoff = null)
    {
        $this->InvBlockCutoff = $invBlockCutoff;
        return $this;
    }
    /**
     * Get CountType value
     * @return string|null
     */
    public function getCountType()
    {
        return $this->CountType;
    }
    /**
     * Set CountType value
     * @param string $countType
     * @return \StructType\InvCount
     */
    public function setCountType($countType = null)
    {
        // validation for constraint: string
        if (!is_null($countType) && !is_string($countType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countType, true), gettype($countType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($countType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $countType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($countType, true)), __LINE__);
        }
        $this->CountType = $countType;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\InvCount
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get AdjustReason value
     * @return string|null
     */
    public function getAdjustReason()
    {
        return $this->AdjustReason;
    }
    /**
     * Set AdjustReason value
     * @param string $adjustReason
     * @return \StructType\InvCount
     */
    public function setAdjustReason($adjustReason = null)
    {
        // validation for constraint: string
        if (!is_null($adjustReason) && !is_string($adjustReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adjustReason, true), gettype($adjustReason)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($adjustReason) && mb_strlen($adjustReason) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($adjustReason)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($adjustReason) && mb_strlen($adjustReason) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($adjustReason)), __LINE__);
        }
        $this->AdjustReason = $adjustReason;
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @param string $actionType
     * @return \StructType\InvCount
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionType, true), gettype($actionType)), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvCount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
