<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to define the details of an inventory block.
 * @subpackage Structs
 */
class InvBlockType extends AbstractStructBase
{
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The InvBlockDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvBlockDates
     */
    public $InvBlockDates;
    /**
     * The RoomTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomTypes
     */
    public $RoomTypes;
    /**
     * The MethodInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MethodInfo
     */
    public $MethodInfo;
    /**
     * The BlockDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BlockDescriptions
     */
    public $BlockDescriptions;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Contacts
     */
    public $Contacts;
    /**
     * The DestinationSystemCodes
     * Meta information extracted from the WSDL
     * - documentation: A collection of destination system codes. These are systems for which this inventory block is targeted.
     * - minOccurs: 0
     * @var \StructType\DestinationSystemCodesType
     */
    public $DestinationSystemCodes;
    /**
     * The BookingStatus
     * @var string
     */
    public $BookingStatus;
    /**
     * The InvBlockTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Describes the type of inventory the block is being created for. Refer to OpenTravel Code List Inventory Block Type (IBT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $InvBlockTypeCode;
    /**
     * The InvBlockCode
     * Meta information extracted from the WSDL
     * - documentation: This is the group id typically used to make a booking in a central reservation system. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $InvBlockCode;
    /**
     * The InvBlockGroupingCode
     * Meta information extracted from the WSDL
     * - documentation: This code identifies the inventory group that contains multiple blocks. This allows for nested blocks. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvBlockGroupingCode;
    /**
     * The InvBlockName
     * Meta information extracted from the WSDL
     * - documentation: This is the short name of the Inventory Block. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $InvBlockName;
    /**
     * The InvBlockLongName
     * Meta information extracted from the WSDL
     * - documentation: This is the full name of the Inventory Block. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $InvBlockLongName;
    /**
     * The InvBlockStatusCode
     * Meta information extracted from the WSDL
     * - documentation: This defines the status of the block. Refer to OpenTravel Code List Inventory Block Status (IBS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $InvBlockStatusCode;
    /**
     * The PMS_InvBlockID
     * Meta information extracted from the WSDL
     * - documentation: This is used as a cross reference to the property management system (e.g. PMS Group Master Number). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $PMS_InvBlockID;
    /**
     * The OpportunityID
     * Meta information extracted from the WSDL
     * - documentation: This is the identifier (i.e. opportunity) that refers back to the same block in the requesting system (e.g. a sales system or a wholesaler). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $OpportunityID;
    /**
     * The InvBlockCompanyID
     * Meta information extracted from the WSDL
     * - documentation: This is used to identify the company or corporation associated with the inventory block, it is not a direct bill number. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $InvBlockCompanyID;
    /**
     * The RestrictedBookingCodeList
     * Meta information extracted from the WSDL
     * - documentation: This is who is allowed to book against the block. Refer to OpenTravel Code List Unique ID Type (UIT). If this attribute is not used, there are no restrictions to the booking access. | Used for codes in the OpenTravel Code tables.
     * Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: ListOfOTA_CodeType
     * - use: optional
     * @var string[]
     */
    public $RestrictedBookingCodeList;
    /**
     * The RestrictedViewingCodeList
     * Meta information extracted from the WSDL
     * - documentation: This is who is allowed to view the block. Refer to OpenTravel Code List Unique ID Type (UIT). If this attribute is not used, there are no restrictions to the viewing access. | Used for codes in the OpenTravel Code tables. Possible
     * values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: ListOfOTA_CodeType
     * - use: optional
     * @var string[]
     */
    public $RestrictedViewingCodeList;
    /**
     * The TransactionAction
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the action to be taken on the block (e.g., create, book, modify, cancel).
     * - type: TransactionActionType
     * - use: optional
     * @var string
     */
    public $TransactionAction;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: This provides the specific action to be taken on the block according to the TransactionAction attribute. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $TransactionDetail;
    /**
     * The QuoteID
     * Meta information extracted from the WSDL
     * - documentation: This identifies a specific quote for an inventory block. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $QuoteID;
    /**
     * Constructor method for InvBlockType
     * @uses InvBlockType::setHotelRef()
     * @uses InvBlockType::setInvBlockDates()
     * @uses InvBlockType::setRoomTypes()
     * @uses InvBlockType::setMethodInfo()
     * @uses InvBlockType::setBlockDescriptions()
     * @uses InvBlockType::setContacts()
     * @uses InvBlockType::setDestinationSystemCodes()
     * @uses InvBlockType::setBookingStatus()
     * @uses InvBlockType::setInvBlockTypeCode()
     * @uses InvBlockType::setInvBlockCode()
     * @uses InvBlockType::setInvBlockGroupingCode()
     * @uses InvBlockType::setInvBlockName()
     * @uses InvBlockType::setInvBlockLongName()
     * @uses InvBlockType::setInvBlockStatusCode()
     * @uses InvBlockType::setPMS_InvBlockID()
     * @uses InvBlockType::setOpportunityID()
     * @uses InvBlockType::setInvBlockCompanyID()
     * @uses InvBlockType::setRestrictedBookingCodeList()
     * @uses InvBlockType::setRestrictedViewingCodeList()
     * @uses InvBlockType::setTransactionAction()
     * @uses InvBlockType::setTransactionDetail()
     * @uses InvBlockType::setQuoteID()
     * @param \StructType\HotelRef $hotelRef
     * @param \StructType\InvBlockDates $invBlockDates
     * @param \StructType\RoomTypes $roomTypes
     * @param \StructType\MethodInfo $methodInfo
     * @param \StructType\BlockDescriptions $blockDescriptions
     * @param \StructType\Contacts $contacts
     * @param \StructType\DestinationSystemCodesType $destinationSystemCodes
     * @param string $bookingStatus
     * @param string $invBlockTypeCode
     * @param string $invBlockCode
     * @param string $invBlockGroupingCode
     * @param string $invBlockName
     * @param string $invBlockLongName
     * @param string $invBlockStatusCode
     * @param string $pMS_InvBlockID
     * @param string $opportunityID
     * @param string $invBlockCompanyID
     * @param string[] $restrictedBookingCodeList
     * @param string[] $restrictedViewingCodeList
     * @param string $transactionAction
     * @param string $transactionDetail
     * @param string $quoteID
     */
    public function __construct(\StructType\HotelRef $hotelRef = null, \StructType\InvBlockDates $invBlockDates = null, \StructType\RoomTypes $roomTypes = null, \StructType\MethodInfo $methodInfo = null, \StructType\BlockDescriptions $blockDescriptions = null, \StructType\Contacts $contacts = null, \StructType\DestinationSystemCodesType $destinationSystemCodes = null, $bookingStatus = null, $invBlockTypeCode = null, $invBlockCode = null, $invBlockGroupingCode = null, $invBlockName = null, $invBlockLongName = null, $invBlockStatusCode = null, $pMS_InvBlockID = null, $opportunityID = null, $invBlockCompanyID = null, array $restrictedBookingCodeList = array(), array $restrictedViewingCodeList = array(), $transactionAction = null, $transactionDetail = null, $quoteID = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setInvBlockDates($invBlockDates)
            ->setRoomTypes($roomTypes)
            ->setMethodInfo($methodInfo)
            ->setBlockDescriptions($blockDescriptions)
            ->setContacts($contacts)
            ->setDestinationSystemCodes($destinationSystemCodes)
            ->setBookingStatus($bookingStatus)
            ->setInvBlockTypeCode($invBlockTypeCode)
            ->setInvBlockCode($invBlockCode)
            ->setInvBlockGroupingCode($invBlockGroupingCode)
            ->setInvBlockName($invBlockName)
            ->setInvBlockLongName($invBlockLongName)
            ->setInvBlockStatusCode($invBlockStatusCode)
            ->setPMS_InvBlockID($pMS_InvBlockID)
            ->setOpportunityID($opportunityID)
            ->setInvBlockCompanyID($invBlockCompanyID)
            ->setRestrictedBookingCodeList($restrictedBookingCodeList)
            ->setRestrictedViewingCodeList($restrictedViewingCodeList)
            ->setTransactionAction($transactionAction)
            ->setTransactionDetail($transactionDetail)
            ->setQuoteID($quoteID);
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\InvBlockType
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get InvBlockDates value
     * @return \StructType\InvBlockDates|null
     */
    public function getInvBlockDates()
    {
        return $this->InvBlockDates;
    }
    /**
     * Set InvBlockDates value
     * @param \StructType\InvBlockDates $invBlockDates
     * @return \StructType\InvBlockType
     */
    public function setInvBlockDates(\StructType\InvBlockDates $invBlockDates = null)
    {
        $this->InvBlockDates = $invBlockDates;
        return $this;
    }
    /**
     * Get RoomTypes value
     * @return \StructType\RoomTypes|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \StructType\RoomTypes $roomTypes
     * @return \StructType\InvBlockType
     */
    public function setRoomTypes(\StructType\RoomTypes $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get MethodInfo value
     * @return \StructType\MethodInfo|null
     */
    public function getMethodInfo()
    {
        return $this->MethodInfo;
    }
    /**
     * Set MethodInfo value
     * @param \StructType\MethodInfo $methodInfo
     * @return \StructType\InvBlockType
     */
    public function setMethodInfo(\StructType\MethodInfo $methodInfo = null)
    {
        $this->MethodInfo = $methodInfo;
        return $this;
    }
    /**
     * Get BlockDescriptions value
     * @return \StructType\BlockDescriptions|null
     */
    public function getBlockDescriptions()
    {
        return $this->BlockDescriptions;
    }
    /**
     * Set BlockDescriptions value
     * @param \StructType\BlockDescriptions $blockDescriptions
     * @return \StructType\InvBlockType
     */
    public function setBlockDescriptions(\StructType\BlockDescriptions $blockDescriptions = null)
    {
        $this->BlockDescriptions = $blockDescriptions;
        return $this;
    }
    /**
     * Get Contacts value
     * @return \StructType\Contacts|null
     */
    public function getContacts()
    {
        return $this->Contacts;
    }
    /**
     * Set Contacts value
     * @param \StructType\Contacts $contacts
     * @return \StructType\InvBlockType
     */
    public function setContacts(\StructType\Contacts $contacts = null)
    {
        $this->Contacts = $contacts;
        return $this;
    }
    /**
     * Get DestinationSystemCodes value
     * @return \StructType\DestinationSystemCodesType|null
     */
    public function getDestinationSystemCodes()
    {
        return $this->DestinationSystemCodes;
    }
    /**
     * Set DestinationSystemCodes value
     * @param \StructType\DestinationSystemCodesType $destinationSystemCodes
     * @return \StructType\InvBlockType
     */
    public function setDestinationSystemCodes(\StructType\DestinationSystemCodesType $destinationSystemCodes = null)
    {
        $this->DestinationSystemCodes = $destinationSystemCodes;
        return $this;
    }
    /**
     * Get BookingStatus value
     * @return string|null
     */
    public function getBookingStatus()
    {
        return $this->BookingStatus;
    }
    /**
     * Set BookingStatus value
     * @param string $bookingStatus
     * @return \StructType\InvBlockType
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($bookingStatus) && !is_string($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingStatus, true), gettype($bookingStatus)), __LINE__);
        }
        $this->BookingStatus = $bookingStatus;
        return $this;
    }
    /**
     * Get InvBlockTypeCode value
     * @return string|null
     */
    public function getInvBlockTypeCode()
    {
        return $this->InvBlockTypeCode;
    }
    /**
     * Set InvBlockTypeCode value
     * @param string $invBlockTypeCode
     * @return \StructType\InvBlockType
     */
    public function setInvBlockTypeCode($invBlockTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockTypeCode) && !is_string($invBlockTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockTypeCode, true), gettype($invBlockTypeCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($invBlockTypeCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $invBlockTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($invBlockTypeCode, true)), __LINE__);
        }
        $this->InvBlockTypeCode = $invBlockTypeCode;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\InvBlockType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($invBlockCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockCode) && mb_strlen($invBlockCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get InvBlockGroupingCode value
     * @return string|null
     */
    public function getInvBlockGroupingCode()
    {
        return $this->InvBlockGroupingCode;
    }
    /**
     * Set InvBlockGroupingCode value
     * @param string $invBlockGroupingCode
     * @return \StructType\InvBlockType
     */
    public function setInvBlockGroupingCode($invBlockGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockGroupingCode) && !is_string($invBlockGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockGroupingCode, true), gettype($invBlockGroupingCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invBlockGroupingCode) && mb_strlen($invBlockGroupingCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invBlockGroupingCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockGroupingCode) && mb_strlen($invBlockGroupingCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockGroupingCode)), __LINE__);
        }
        $this->InvBlockGroupingCode = $invBlockGroupingCode;
        return $this;
    }
    /**
     * Get InvBlockName value
     * @return string|null
     */
    public function getInvBlockName()
    {
        return $this->InvBlockName;
    }
    /**
     * Set InvBlockName value
     * @param string $invBlockName
     * @return \StructType\InvBlockType
     */
    public function setInvBlockName($invBlockName = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockName) && !is_string($invBlockName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockName, true), gettype($invBlockName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($invBlockName) && mb_strlen($invBlockName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($invBlockName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockName) && mb_strlen($invBlockName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockName)), __LINE__);
        }
        $this->InvBlockName = $invBlockName;
        return $this;
    }
    /**
     * Get InvBlockLongName value
     * @return string|null
     */
    public function getInvBlockLongName()
    {
        return $this->InvBlockLongName;
    }
    /**
     * Set InvBlockLongName value
     * @param string $invBlockLongName
     * @return \StructType\InvBlockType
     */
    public function setInvBlockLongName($invBlockLongName = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockLongName) && !is_string($invBlockLongName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockLongName, true), gettype($invBlockLongName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($invBlockLongName) && mb_strlen($invBlockLongName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($invBlockLongName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockLongName) && mb_strlen($invBlockLongName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockLongName)), __LINE__);
        }
        $this->InvBlockLongName = $invBlockLongName;
        return $this;
    }
    /**
     * Get InvBlockStatusCode value
     * @return string|null
     */
    public function getInvBlockStatusCode()
    {
        return $this->InvBlockStatusCode;
    }
    /**
     * Set InvBlockStatusCode value
     * @param string $invBlockStatusCode
     * @return \StructType\InvBlockType
     */
    public function setInvBlockStatusCode($invBlockStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockStatusCode) && !is_string($invBlockStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockStatusCode, true), gettype($invBlockStatusCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($invBlockStatusCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $invBlockStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($invBlockStatusCode, true)), __LINE__);
        }
        $this->InvBlockStatusCode = $invBlockStatusCode;
        return $this;
    }
    /**
     * Get PMS_InvBlockID value
     * @return string|null
     */
    public function getPMS_InvBlockID()
    {
        return $this->PMS_InvBlockID;
    }
    /**
     * Set PMS_InvBlockID value
     * @param string $pMS_InvBlockID
     * @return \StructType\InvBlockType
     */
    public function setPMS_InvBlockID($pMS_InvBlockID = null)
    {
        // validation for constraint: string
        if (!is_null($pMS_InvBlockID) && !is_string($pMS_InvBlockID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMS_InvBlockID, true), gettype($pMS_InvBlockID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pMS_InvBlockID) && mb_strlen($pMS_InvBlockID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pMS_InvBlockID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pMS_InvBlockID) && mb_strlen($pMS_InvBlockID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pMS_InvBlockID)), __LINE__);
        }
        $this->PMS_InvBlockID = $pMS_InvBlockID;
        return $this;
    }
    /**
     * Get OpportunityID value
     * @return string|null
     */
    public function getOpportunityID()
    {
        return $this->OpportunityID;
    }
    /**
     * Set OpportunityID value
     * @param string $opportunityID
     * @return \StructType\InvBlockType
     */
    public function setOpportunityID($opportunityID = null)
    {
        // validation for constraint: string
        if (!is_null($opportunityID) && !is_string($opportunityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opportunityID, true), gettype($opportunityID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($opportunityID) && mb_strlen($opportunityID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($opportunityID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($opportunityID) && mb_strlen($opportunityID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($opportunityID)), __LINE__);
        }
        $this->OpportunityID = $opportunityID;
        return $this;
    }
    /**
     * Get InvBlockCompanyID value
     * @return string|null
     */
    public function getInvBlockCompanyID()
    {
        return $this->InvBlockCompanyID;
    }
    /**
     * Set InvBlockCompanyID value
     * @param string $invBlockCompanyID
     * @return \StructType\InvBlockType
     */
    public function setInvBlockCompanyID($invBlockCompanyID = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCompanyID) && !is_string($invBlockCompanyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCompanyID, true), gettype($invBlockCompanyID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($invBlockCompanyID) && mb_strlen($invBlockCompanyID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($invBlockCompanyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invBlockCompanyID) && mb_strlen($invBlockCompanyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invBlockCompanyID)), __LINE__);
        }
        $this->InvBlockCompanyID = $invBlockCompanyID;
        return $this;
    }
    /**
     * Get RestrictedBookingCodeList value
     * @return string[]|null
     */
    public function getRestrictedBookingCodeList()
    {
        return $this->RestrictedBookingCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrictedBookingCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrictedBookingCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictedBookingCodeListForArrayConstraintsFromSetRestrictedBookingCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlockTypeRestrictedBookingCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($invBlockTypeRestrictedBookingCodeListItem)) {
                $invalidValues[] = is_object($invBlockTypeRestrictedBookingCodeListItem) ? get_class($invBlockTypeRestrictedBookingCodeListItem) : sprintf('%s(%s)', gettype($invBlockTypeRestrictedBookingCodeListItem), var_export($invBlockTypeRestrictedBookingCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RestrictedBookingCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RestrictedBookingCodeList value
     * @param string[] $restrictedBookingCodeList
     * @return \StructType\InvBlockType
     */
    public function setRestrictedBookingCodeList(array $restrictedBookingCodeList = array())
    {
        // validation for constraint: list
        if ('' !== ($restrictedBookingCodeListArrayErrorMessage = self::validateRestrictedBookingCodeListForArrayConstraintsFromSetRestrictedBookingCodeList($restrictedBookingCodeList))) {
            throw new \InvalidArgumentException($restrictedBookingCodeListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($restrictedBookingCodeList) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $restrictedBookingCodeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($restrictedBookingCodeList, true)), __LINE__);
        }
        $this->RestrictedBookingCodeList = is_array($restrictedBookingCodeList) ? implode(' ', $restrictedBookingCodeList) : null;
        return $this;
    }
    /**
     * Get RestrictedViewingCodeList value
     * @return string[]|null
     */
    public function getRestrictedViewingCodeList()
    {
        return $this->RestrictedViewingCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrictedViewingCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrictedViewingCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictedViewingCodeListForArrayConstraintsFromSetRestrictedViewingCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlockTypeRestrictedViewingCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($invBlockTypeRestrictedViewingCodeListItem)) {
                $invalidValues[] = is_object($invBlockTypeRestrictedViewingCodeListItem) ? get_class($invBlockTypeRestrictedViewingCodeListItem) : sprintf('%s(%s)', gettype($invBlockTypeRestrictedViewingCodeListItem), var_export($invBlockTypeRestrictedViewingCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RestrictedViewingCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RestrictedViewingCodeList value
     * @param string[] $restrictedViewingCodeList
     * @return \StructType\InvBlockType
     */
    public function setRestrictedViewingCodeList(array $restrictedViewingCodeList = array())
    {
        // validation for constraint: list
        if ('' !== ($restrictedViewingCodeListArrayErrorMessage = self::validateRestrictedViewingCodeListForArrayConstraintsFromSetRestrictedViewingCodeList($restrictedViewingCodeList))) {
            throw new \InvalidArgumentException($restrictedViewingCodeListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($restrictedViewingCodeList) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $restrictedViewingCodeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($restrictedViewingCodeList, true)), __LINE__);
        }
        $this->RestrictedViewingCodeList = is_array($restrictedViewingCodeList) ? implode(' ', $restrictedViewingCodeList) : null;
        return $this;
    }
    /**
     * Get TransactionAction value
     * @return string|null
     */
    public function getTransactionAction()
    {
        return $this->TransactionAction;
    }
    /**
     * Set TransactionAction value
     * @uses \EnumType\TransactionActionType::valueIsValid()
     * @uses \EnumType\TransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionAction
     * @return \StructType\InvBlockType
     */
    public function setTransactionAction($transactionAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionActionType::valueIsValid($transactionAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionActionType', is_array($transactionAction) ? implode(', ', $transactionAction) : var_export($transactionAction, true), implode(', ', \EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        $this->TransactionAction = $transactionAction;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return string|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param string $transactionDetail
     * @return \StructType\InvBlockType
     */
    public function setTransactionDetail($transactionDetail = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDetail) && !is_string($transactionDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDetail, true), gettype($transactionDetail)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($transactionDetail) && mb_strlen($transactionDetail) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($transactionDetail)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($transactionDetail) && mb_strlen($transactionDetail) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($transactionDetail)), __LINE__);
        }
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return string|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param string $quoteID
     * @return \StructType\InvBlockType
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: string
        if (!is_null($quoteID) && !is_string($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteID, true), gettype($quoteID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($quoteID) && mb_strlen($quoteID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($quoteID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($quoteID) && mb_strlen($quoteID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlockType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
