<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockRoomType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the date range to which rooms are assigned to the inventory block. | Used to define the room types and all of their supporting data within a room block.
 * @subpackage Structs
 */
class InvBlockRoomType extends AbstractStructBase
{
    /**
     * The RoomTypeAllocations
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\RoomTypeAllocations[]
     */
    public $RoomTypeAllocations;
    /**
     * The RatePlans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlans
     */
    public $RatePlans;
    /**
     * The DaysOfWeeks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DaysOfWeeks
     */
    public $DaysOfWeeks;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specfic system room type code (e.g. GENR, CONC, SUIT). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for InvBlockRoomType
     * @uses InvBlockRoomType::setRoomTypeAllocations()
     * @uses InvBlockRoomType::setRatePlans()
     * @uses InvBlockRoomType::setDaysOfWeeks()
     * @uses InvBlockRoomType::setRoomTypeCode()
     * @uses InvBlockRoomType::setStart()
     * @uses InvBlockRoomType::setDuration()
     * @uses InvBlockRoomType::setEnd()
     * @param \StructType\RoomTypeAllocations[] $roomTypeAllocations
     * @param \StructType\RatePlans $ratePlans
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @param string $roomTypeCode
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(array $roomTypeAllocations = array(), \StructType\RatePlans $ratePlans = null, \StructType\DaysOfWeeks $daysOfWeeks = null, $roomTypeCode = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setRoomTypeAllocations($roomTypeAllocations)
            ->setRatePlans($ratePlans)
            ->setDaysOfWeeks($daysOfWeeks)
            ->setRoomTypeCode($roomTypeCode)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get RoomTypeAllocations value
     * @return \StructType\RoomTypeAllocations[]|null
     */
    public function getRoomTypeAllocations()
    {
        return $this->RoomTypeAllocations;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomTypeAllocations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomTypeAllocations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomTypeAllocationsForArrayConstraintsFromSetRoomTypeAllocations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlockRoomTypeRoomTypeAllocationsItem) {
            // validation for constraint: itemType
            if (!$invBlockRoomTypeRoomTypeAllocationsItem instanceof \StructType\RoomTypeAllocations) {
                $invalidValues[] = is_object($invBlockRoomTypeRoomTypeAllocationsItem) ? get_class($invBlockRoomTypeRoomTypeAllocationsItem) : sprintf('%s(%s)', gettype($invBlockRoomTypeRoomTypeAllocationsItem), var_export($invBlockRoomTypeRoomTypeAllocationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomTypeAllocations property can only contain items of type \StructType\RoomTypeAllocations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomTypeAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocations[] $roomTypeAllocations
     * @return \StructType\InvBlockRoomType
     */
    public function setRoomTypeAllocations(array $roomTypeAllocations = array())
    {
        // validation for constraint: array
        if ('' !== ($roomTypeAllocationsArrayErrorMessage = self::validateRoomTypeAllocationsForArrayConstraintsFromSetRoomTypeAllocations($roomTypeAllocations))) {
            throw new \InvalidArgumentException($roomTypeAllocationsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($roomTypeAllocations) && count($roomTypeAllocations) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($roomTypeAllocations)), __LINE__);
        }
        $this->RoomTypeAllocations = $roomTypeAllocations;
        return $this;
    }
    /**
     * Add item to RoomTypeAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocations $item
     * @return \StructType\InvBlockRoomType
     */
    public function addToRoomTypeAllocations(\StructType\RoomTypeAllocations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomTypeAllocations) {
            throw new \InvalidArgumentException(sprintf('The RoomTypeAllocations property can only contain items of type \StructType\RoomTypeAllocations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->RoomTypeAllocations) && count($this->RoomTypeAllocations) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->RoomTypeAllocations)), __LINE__);
        }
        $this->RoomTypeAllocations[] = $item;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \StructType\RatePlans|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \StructType\RatePlans $ratePlans
     * @return \StructType\InvBlockRoomType
     */
    public function setRatePlans(\StructType\RatePlans $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get DaysOfWeeks value
     * @return \StructType\DaysOfWeeks|null
     */
    public function getDaysOfWeeks()
    {
        return $this->DaysOfWeeks;
    }
    /**
     * Set DaysOfWeeks value
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @return \StructType\InvBlockRoomType
     */
    public function setDaysOfWeeks(\StructType\DaysOfWeeks $daysOfWeeks = null)
    {
        $this->DaysOfWeeks = $daysOfWeeks;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\InvBlockRoomType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\InvBlockRoomType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\InvBlockRoomType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\InvBlockRoomType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlockRoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
