<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of types of restaurant.
 * @subpackage Structs
 */
class InfoCodes extends AbstractStructBase
{
    /**
     * The InfoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\InfoCode[]
     */
    public $InfoCode;
    /**
     * Constructor method for InfoCodes
     * @uses InfoCodes::setInfoCode()
     * @param \StructType\InfoCode[] $infoCode
     */
    public function __construct(array $infoCode = array())
    {
        $this
            ->setInfoCode($infoCode);
    }
    /**
     * Get InfoCode value
     * @return \StructType\InfoCode[]|null
     */
    public function getInfoCode()
    {
        return $this->InfoCode;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoCodeForArrayConstraintsFromSetInfoCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $infoCodesInfoCodeItem) {
            // validation for constraint: itemType
            if (!$infoCodesInfoCodeItem instanceof \StructType\InfoCode) {
                $invalidValues[] = is_object($infoCodesInfoCodeItem) ? get_class($infoCodesInfoCodeItem) : sprintf('%s(%s)', gettype($infoCodesInfoCodeItem), var_export($infoCodesInfoCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InfoCode property can only contain items of type \StructType\InfoCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InfoCode value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoCode[] $infoCode
     * @return \StructType\InfoCodes
     */
    public function setInfoCode(array $infoCode = array())
    {
        // validation for constraint: array
        if ('' !== ($infoCodeArrayErrorMessage = self::validateInfoCodeForArrayConstraintsFromSetInfoCode($infoCode))) {
            throw new \InvalidArgumentException($infoCodeArrayErrorMessage, __LINE__);
        }
        $this->InfoCode = $infoCode;
        return $this;
    }
    /**
     * Add item to InfoCode value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoCode $item
     * @return \StructType\InfoCodes
     */
    public function addToInfoCode(\StructType\InfoCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoCode) {
            throw new \InvalidArgumentException(sprintf('The InfoCode property can only contain items of type \StructType\InfoCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InfoCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
