<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of single search criterion items.
 * @subpackage Structs
 */
class HotelSearchCriteriaType extends AbstractStructBase
{
    /**
     * The Criterion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Criterion[]
     */
    public $Criterion;
    /**
     * The AvailableOnlyIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, return only hotels that are available.
     * - use: optional
     * @var bool
     */
    public $AvailableOnlyIndicator;
    /**
     * The BestOnlyIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, return only the lowest room rate for hotels that are available.
     * @var bool
     */
    public $BestOnlyIndicator;
    /**
     * Constructor method for HotelSearchCriteriaType
     * @uses HotelSearchCriteriaType::setCriterion()
     * @uses HotelSearchCriteriaType::setAvailableOnlyIndicator()
     * @uses HotelSearchCriteriaType::setBestOnlyIndicator()
     * @param \StructType\Criterion[] $criterion
     * @param bool $availableOnlyIndicator
     * @param bool $bestOnlyIndicator
     */
    public function __construct(array $criterion = array(), $availableOnlyIndicator = null, $bestOnlyIndicator = null)
    {
        $this
            ->setCriterion($criterion)
            ->setAvailableOnlyIndicator($availableOnlyIndicator)
            ->setBestOnlyIndicator($bestOnlyIndicator);
    }
    /**
     * Get Criterion value
     * @return \StructType\Criterion[]|null
     */
    public function getCriterion()
    {
        return $this->Criterion;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionForArrayConstraintsFromSetCriterion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriteriaTypeCriterionItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriteriaTypeCriterionItem instanceof \StructType\Criterion) {
                $invalidValues[] = is_object($hotelSearchCriteriaTypeCriterionItem) ? get_class($hotelSearchCriteriaTypeCriterionItem) : sprintf('%s(%s)', gettype($hotelSearchCriteriaTypeCriterionItem), var_export($hotelSearchCriteriaTypeCriterionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Criterion property can only contain items of type \StructType\Criterion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Criterion value
     * @throws \InvalidArgumentException
     * @param \StructType\Criterion[] $criterion
     * @return \StructType\HotelSearchCriteriaType
     */
    public function setCriterion(array $criterion = array())
    {
        // validation for constraint: array
        if ('' !== ($criterionArrayErrorMessage = self::validateCriterionForArrayConstraintsFromSetCriterion($criterion))) {
            throw new \InvalidArgumentException($criterionArrayErrorMessage, __LINE__);
        }
        $this->Criterion = $criterion;
        return $this;
    }
    /**
     * Add item to Criterion value
     * @throws \InvalidArgumentException
     * @param \StructType\Criterion $item
     * @return \StructType\HotelSearchCriteriaType
     */
    public function addToCriterion(\StructType\Criterion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Criterion) {
            throw new \InvalidArgumentException(sprintf('The Criterion property can only contain items of type \StructType\Criterion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Criterion[] = $item;
        return $this;
    }
    /**
     * Get AvailableOnlyIndicator value
     * @return bool|null
     */
    public function getAvailableOnlyIndicator()
    {
        return $this->AvailableOnlyIndicator;
    }
    /**
     * Set AvailableOnlyIndicator value
     * @param bool $availableOnlyIndicator
     * @return \StructType\HotelSearchCriteriaType
     */
    public function setAvailableOnlyIndicator($availableOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnlyIndicator) && !is_bool($availableOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableOnlyIndicator, true), gettype($availableOnlyIndicator)), __LINE__);
        }
        $this->AvailableOnlyIndicator = $availableOnlyIndicator;
        return $this;
    }
    /**
     * Get BestOnlyIndicator value
     * @return bool|null
     */
    public function getBestOnlyIndicator()
    {
        return $this->BestOnlyIndicator;
    }
    /**
     * Set BestOnlyIndicator value
     * @param bool $bestOnlyIndicator
     * @return \StructType\HotelSearchCriteriaType
     */
    public function setBestOnlyIndicator($bestOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($bestOnlyIndicator) && !is_bool($bestOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bestOnlyIndicator, true), gettype($bestOnlyIndicator)), __LINE__);
        }
        $this->BestOnlyIndicator = $bestOnlyIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelSearchCriteriaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
