<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of hotel reservations.
 * @subpackage Structs
 */
class HotelReservationsType extends AbstractStructBase
{
    /**
     * The HotelReservation
     * Meta information extracted from the WSDL
     * - documentation: Contains a hotel reservation.
     * - maxOccurs: unbounded
     * @var \StructType\HotelReservationType[]
     */
    public $HotelReservation;
    /**
     * The RoutingHops
     * Meta information extracted from the WSDL
     * - documentation: A collection of routing hops.
     * - minOccurs: 0
     * @var \StructType\RoutingHopType
     */
    public $RoutingHops;
    /**
     * The WrittenConfInst
     * Meta information extracted from the WSDL
     * - documentation: To indicate a confirmation is to be sent for this batch of reservations.
     * - minOccurs: 0
     * @var \StructType\WrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * Constructor method for HotelReservationsType
     * @uses HotelReservationsType::setHotelReservation()
     * @uses HotelReservationsType::setRoutingHops()
     * @uses HotelReservationsType::setWrittenConfInst()
     * @uses HotelReservationsType::setTPA_Extensions()
     * @param \StructType\HotelReservationType[] $hotelReservation
     * @param \StructType\RoutingHopType $routingHops
     * @param \StructType\WrittenConfInstType $writtenConfInst
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     */
    public function __construct(array $hotelReservation = array(), \StructType\RoutingHopType $routingHops = null, \StructType\WrittenConfInstType $writtenConfInst = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this
            ->setHotelReservation($hotelReservation)
            ->setRoutingHops($routingHops)
            ->setWrittenConfInst($writtenConfInst)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get HotelReservation value
     * @return \StructType\HotelReservationType[]|null
     */
    public function getHotelReservation()
    {
        return $this->HotelReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelReservationForArrayConstraintsFromSetHotelReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelReservationsTypeHotelReservationItem) {
            // validation for constraint: itemType
            if (!$hotelReservationsTypeHotelReservationItem instanceof \StructType\HotelReservationType) {
                $invalidValues[] = is_object($hotelReservationsTypeHotelReservationItem) ? get_class($hotelReservationsTypeHotelReservationItem) : sprintf('%s(%s)', gettype($hotelReservationsTypeHotelReservationItem), var_export($hotelReservationsTypeHotelReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelReservation property can only contain items of type \StructType\HotelReservationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservationType[] $hotelReservation
     * @return \StructType\HotelReservationsType
     */
    public function setHotelReservation(array $hotelReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelReservationArrayErrorMessage = self::validateHotelReservationForArrayConstraintsFromSetHotelReservation($hotelReservation))) {
            throw new \InvalidArgumentException($hotelReservationArrayErrorMessage, __LINE__);
        }
        $this->HotelReservation = $hotelReservation;
        return $this;
    }
    /**
     * Add item to HotelReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservationType $item
     * @return \StructType\HotelReservationsType
     */
    public function addToHotelReservation(\StructType\HotelReservationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelReservationType) {
            throw new \InvalidArgumentException(sprintf('The HotelReservation property can only contain items of type \StructType\HotelReservationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelReservation[] = $item;
        return $this;
    }
    /**
     * Get RoutingHops value
     * @return \StructType\RoutingHopType|null
     */
    public function getRoutingHops()
    {
        return $this->RoutingHops;
    }
    /**
     * Set RoutingHops value
     * @param \StructType\RoutingHopType $routingHops
     * @return \StructType\HotelReservationsType
     */
    public function setRoutingHops(\StructType\RoutingHopType $routingHops = null)
    {
        $this->RoutingHops = $routingHops;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \StructType\WrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \StructType\WrittenConfInstType $writtenConfInst
     * @return \StructType\HotelReservationsType
     */
    public function setWrittenConfInst(\StructType\WrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\HotelReservationsType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelReservationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
