<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelResModify StructType
 * Meta information extracted from the WSDL
 * - documentation: A full overlay of reservation information containing the modified data.
 * @subpackage Structs
 */
class HotelResModify extends HotelReservationType
{
    /**
     * The Verification
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Verification[]
     */
    public $Verification;
    /**
     * Constructor method for HotelResModify
     * @uses HotelResModify::setVerification()
     * @param \StructType\Verification[] $verification
     */
    public function __construct(array $verification = array())
    {
        $this
            ->setVerification($verification);
    }
    /**
     * Get Verification value
     * @return \StructType\Verification[]|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * This method is responsible for validating the values passed to the setVerification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerificationForArrayConstraintsFromSetVerification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelResModifyVerificationItem) {
            // validation for constraint: itemType
            if (!$hotelResModifyVerificationItem instanceof \StructType\Verification) {
                $invalidValues[] = is_object($hotelResModifyVerificationItem) ? get_class($hotelResModifyVerificationItem) : sprintf('%s(%s)', gettype($hotelResModifyVerificationItem), var_export($hotelResModifyVerificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Verification property can only contain items of type \StructType\Verification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Verification value
     * @throws \InvalidArgumentException
     * @param \StructType\Verification[] $verification
     * @return \StructType\HotelResModify
     */
    public function setVerification(array $verification = array())
    {
        // validation for constraint: array
        if ('' !== ($verificationArrayErrorMessage = self::validateVerificationForArrayConstraintsFromSetVerification($verification))) {
            throw new \InvalidArgumentException($verificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($verification) && count($verification) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($verification)), __LINE__);
        }
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Add item to Verification value
     * @throws \InvalidArgumentException
     * @param \StructType\Verification $item
     * @return \StructType\HotelResModify
     */
    public function addToVerification(\StructType\Verification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Verification) {
            throw new \InvalidArgumentException(sprintf('The Verification property can only contain items of type \StructType\Verification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Verification) && count($this->Verification) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Verification)), __LINE__);
        }
        $this->Verification[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelResModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
