<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestCount StructType
 * Meta information extracted from the WSDL
 * - documentation: A recurring element that identifies the number of guests and ages of the guests.
 * @subpackage Structs
 */
class GuestCount extends AbstractStructBase
{
    /**
     * The ResGuestRPH
     * Meta information extracted from the WSDL
     * - documentation: Used to refer to the guest associated with this reservation. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $ResGuestRPH;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: A code representing a business rule that determines the charges for a guest based upon age range (e.g. Adult, Child, Senior, Child With Adult, Child Without Adult). This attribute allows for an increase in rate by occupant class.
     * Refer to OpenTravel Code List Age Qualifying Code (AQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - documentation: Defines the age of a guest. | Used for Numeric values, from 0 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 0
     * - type: Numeric0to999
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - documentation: The number of guests in one AgeQualifyingCode or Count. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $Count;
    /**
     * Constructor method for GuestCount
     * @uses GuestCount::setResGuestRPH()
     * @uses GuestCount::setAgeQualifyingCode()
     * @uses GuestCount::setAge()
     * @uses GuestCount::setCount()
     * @param string $resGuestRPH
     * @param string $ageQualifyingCode
     * @param int $age
     * @param int $count
     */
    public function __construct($resGuestRPH = null, $ageQualifyingCode = null, $age = null, $count = null)
    {
        $this
            ->setResGuestRPH($resGuestRPH)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setAge($age)
            ->setCount($count);
    }
    /**
     * Get ResGuestRPH value
     * @return string|null
     */
    public function getResGuestRPH()
    {
        return $this->ResGuestRPH;
    }
    /**
     * Set ResGuestRPH value
     * @param string $resGuestRPH
     * @return \StructType\GuestCount
     */
    public function setResGuestRPH($resGuestRPH = null)
    {
        // validation for constraint: string
        if (!is_null($resGuestRPH) && !is_string($resGuestRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resGuestRPH, true), gettype($resGuestRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($resGuestRPH) && !preg_match('/[0-9]{1,8}/', $resGuestRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($resGuestRPH, true)), __LINE__);
        }
        $this->ResGuestRPH = $resGuestRPH;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\GuestCount
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\GuestCount
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($age) && $age > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($age, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($age) && $age < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($age, true)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\GuestCount
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($count) && $count > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($count) && $count < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($count, true)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestCount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
