<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteeType StructType
 * Meta information extracted from the WSDL
 * - documentation: GuaranteeType: GuaranteeType An enumerated type defining the guarantee to be applied to this reservation. | The guarantee information to hold a reservation
 * @subpackage Structs
 */
class GuaranteeType extends AbstractStructBase
{
    /**
     * The GuaranteesAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuaranteesAccepted
     */
    public $GuaranteesAccepted;
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Deadline
     */
    public $Deadline;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommentType
     */
    public $Comments;
    /**
     * The GuaranteeDescription
     * Meta information extracted from the WSDL
     * - documentation: Text description of the Guarantee in a given language.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $GuaranteeDescription;
    /**
     * The RetributionType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RetributionType;
    /**
     * The GuaranteeCode
     * Meta information extracted from the WSDL
     * - documentation: Guarantee Code | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $GuaranteeCode;
    /**
     * The GuaranteeType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $GuaranteeType;
    /**
     * The HoldTime
     * Meta information extracted from the WSDL
     * - documentation: The room will held up until this time without a guarantee.
     * - use: optional
     * @var string
     */
    public $HoldTime;
    /**
     * Constructor method for GuaranteeType
     * @uses GuaranteeType::setGuaranteesAccepted()
     * @uses GuaranteeType::setDeadline()
     * @uses GuaranteeType::setComments()
     * @uses GuaranteeType::setGuaranteeDescription()
     * @uses GuaranteeType::setRetributionType()
     * @uses GuaranteeType::setGuaranteeCode()
     * @uses GuaranteeType::setGuaranteeType()
     * @uses GuaranteeType::setHoldTime()
     * @param \StructType\GuaranteesAccepted $guaranteesAccepted
     * @param \StructType\Deadline $deadline
     * @param \StructType\CommentType $comments
     * @param \StructType\ParagraphType[] $guaranteeDescription
     * @param string $retributionType
     * @param string $guaranteeCode
     * @param string $guaranteeType
     * @param string $holdTime
     */
    public function __construct(\StructType\GuaranteesAccepted $guaranteesAccepted = null, \StructType\Deadline $deadline = null, \StructType\CommentType $comments = null, array $guaranteeDescription = array(), $retributionType = null, $guaranteeCode = null, $guaranteeType = null, $holdTime = null)
    {
        $this
            ->setGuaranteesAccepted($guaranteesAccepted)
            ->setDeadline($deadline)
            ->setComments($comments)
            ->setGuaranteeDescription($guaranteeDescription)
            ->setRetributionType($retributionType)
            ->setGuaranteeCode($guaranteeCode)
            ->setGuaranteeType($guaranteeType)
            ->setHoldTime($holdTime);
    }
    /**
     * Get GuaranteesAccepted value
     * @return \StructType\GuaranteesAccepted|null
     */
    public function getGuaranteesAccepted()
    {
        return $this->GuaranteesAccepted;
    }
    /**
     * Set GuaranteesAccepted value
     * @param \StructType\GuaranteesAccepted $guaranteesAccepted
     * @return \StructType\GuaranteeType
     */
    public function setGuaranteesAccepted(\StructType\GuaranteesAccepted $guaranteesAccepted = null)
    {
        $this->GuaranteesAccepted = $guaranteesAccepted;
        return $this;
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * Set Deadline value
     * @param \StructType\Deadline $deadline
     * @return \StructType\GuaranteeType
     */
    public function setDeadline(\StructType\Deadline $deadline = null)
    {
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\CommentType|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\CommentType $comments
     * @return \StructType\GuaranteeType
     */
    public function setComments(\StructType\CommentType $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get GuaranteeDescription value
     * @return \StructType\ParagraphType[]|null
     */
    public function getGuaranteeDescription()
    {
        return $this->GuaranteeDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setGuaranteeDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuaranteeDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteeDescriptionForArrayConstraintsFromSetGuaranteeDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteeTypeGuaranteeDescriptionItem) {
            // validation for constraint: itemType
            if (!$guaranteeTypeGuaranteeDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($guaranteeTypeGuaranteeDescriptionItem) ? get_class($guaranteeTypeGuaranteeDescriptionItem) : sprintf('%s(%s)', gettype($guaranteeTypeGuaranteeDescriptionItem), var_export($guaranteeTypeGuaranteeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuaranteeDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuaranteeDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $guaranteeDescription
     * @return \StructType\GuaranteeType
     */
    public function setGuaranteeDescription(array $guaranteeDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteeDescriptionArrayErrorMessage = self::validateGuaranteeDescriptionForArrayConstraintsFromSetGuaranteeDescription($guaranteeDescription))) {
            throw new \InvalidArgumentException($guaranteeDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($guaranteeDescription) && count($guaranteeDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($guaranteeDescription)), __LINE__);
        }
        $this->GuaranteeDescription = $guaranteeDescription;
        return $this;
    }
    /**
     * Add item to GuaranteeDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\GuaranteeType
     */
    public function addToGuaranteeDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The GuaranteeDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->GuaranteeDescription) && count($this->GuaranteeDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->GuaranteeDescription)), __LINE__);
        }
        $this->GuaranteeDescription[] = $item;
        return $this;
    }
    /**
     * Get RetributionType value
     * @return string|null
     */
    public function getRetributionType()
    {
        return $this->RetributionType;
    }
    /**
     * Set RetributionType value
     * @param string $retributionType
     * @return \StructType\GuaranteeType
     */
    public function setRetributionType($retributionType = null)
    {
        // validation for constraint: string
        if (!is_null($retributionType) && !is_string($retributionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retributionType, true), gettype($retributionType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($retributionType) && mb_strlen($retributionType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($retributionType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($retributionType) && mb_strlen($retributionType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($retributionType)), __LINE__);
        }
        $this->RetributionType = $retributionType;
        return $this;
    }
    /**
     * Get GuaranteeCode value
     * @return string|null
     */
    public function getGuaranteeCode()
    {
        return $this->GuaranteeCode;
    }
    /**
     * Set GuaranteeCode value
     * @param string $guaranteeCode
     * @return \StructType\GuaranteeType
     */
    public function setGuaranteeCode($guaranteeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeCode) && !is_string($guaranteeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeCode, true), gettype($guaranteeCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($guaranteeCode) && mb_strlen($guaranteeCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($guaranteeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($guaranteeCode) && mb_strlen($guaranteeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($guaranteeCode)), __LINE__);
        }
        $this->GuaranteeCode = $guaranteeCode;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \StructType\GuaranteeType
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeType) && !is_string($guaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeType, true), gettype($guaranteeType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($guaranteeType) && mb_strlen($guaranteeType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($guaranteeType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($guaranteeType) && mb_strlen($guaranteeType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($guaranteeType)), __LINE__);
        }
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get HoldTime value
     * @return string|null
     */
    public function getHoldTime()
    {
        return $this->HoldTime;
    }
    /**
     * Set HoldTime value
     * @param string $holdTime
     * @return \StructType\GuaranteeType
     */
    public function setHoldTime($holdTime = null)
    {
        // validation for constraint: string
        if (!is_null($holdTime) && !is_string($holdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdTime, true), gettype($holdTime)), __LINE__);
        }
        $this->HoldTime = $holdTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuaranteeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
