<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteePayment StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to define the deposit policy, guarantees policy, and/or accepted forms of payment. | Guarantee or Payment information for an individual guest.
 * @subpackage Structs
 */
class GuaranteePayment extends HotelPaymentFormType
{
    /**
     * The DetailType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DetailType;
    /**
     * The GuaranteeType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $GuaranteeType;
    /**
     * The AcceptedPayments
     * Meta information extracted from the WSDL
     * - documentation: Collection of forms of payment accepted for payment.
     * - minOccurs: 0
     * @var \StructType\AcceptedPaymentsType
     */
    public $AcceptedPayments;
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AmountPercent
     */
    public $AmountPercent;
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\Deadline[]
     */
    public $Deadline;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Text description of the Payment in a given language.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The RetributionType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RetributionType;
    /**
     * The PaymentCode
     * Meta information extracted from the WSDL
     * - documentation: This defines the form of payment. Recommended usage of this is with the Payment Type in OpenTravel Code List, this datatype will be updated in the future. In order to maintain forward compatability a change is not being made in this
     * publication. This will be corrected in a future version, when a major update is released. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PaymentCode;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The GuaranteeCode
     * Meta information extracted from the WSDL
     * - documentation: Guarantee Code | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $GuaranteeCode;
    /**
     * The HoldTime
     * Meta information extracted from the WSDL
     * - documentation: The room will held up until this time without a guarantee.
     * - use: optional
     * @var string
     */
    public $HoldTime;
    /**
     * The NoCardHolderInfoReqInd
     * Meta information extracted from the WSDL
     * - documentation: If true, no credit cardholder information is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $NoCardHolderInfoReqInd;
    /**
     * The NameInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the credit cardholder name is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $NameInd;
    /**
     * The AddressInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the credit cardholder address is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $AddressInd;
    /**
     * The PhoneInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the credit cardholder phone number is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $PhoneInd;
    /**
     * The InterbankNbrInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the Interbank Card Association number is required for guarantee/deposit.
     * - use: optional
     * @var bool
     */
    public $InterbankNbrInd;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A system specific room type to which this guarantee payment information applies. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InfoSource
     * Meta information extracted from the WSDL
     * - documentation: To specify the source of the rate of exchange for a currency code. | Used to specify the source of the data being exchanged.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The NonRefundableIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that any prepayment for the reservation is non refundable, therefore a 100% penalty on the prepayment is applied, irrespective of deadline.
     * - use: optional
     * @var bool
     */
    public $NonRefundableIndicator;
    /**
     * The PolicyCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the type of payment policy. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PolicyCode;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for GuaranteePayment
     * @uses GuaranteePayment::setDetailType()
     * @uses GuaranteePayment::setGuaranteeType()
     * @uses GuaranteePayment::setAcceptedPayments()
     * @uses GuaranteePayment::setAmountPercent()
     * @uses GuaranteePayment::setDeadline()
     * @uses GuaranteePayment::setDescription()
     * @uses GuaranteePayment::setAddress()
     * @uses GuaranteePayment::setTPA_Extensions()
     * @uses GuaranteePayment::setRetributionType()
     * @uses GuaranteePayment::setPaymentCode()
     * @uses GuaranteePayment::setType()
     * @uses GuaranteePayment::setGuaranteeCode()
     * @uses GuaranteePayment::setHoldTime()
     * @uses GuaranteePayment::setNoCardHolderInfoReqInd()
     * @uses GuaranteePayment::setNameInd()
     * @uses GuaranteePayment::setAddressInd()
     * @uses GuaranteePayment::setPhoneInd()
     * @uses GuaranteePayment::setInterbankNbrInd()
     * @uses GuaranteePayment::setRoomTypeCode()
     * @uses GuaranteePayment::setInfoSource()
     * @uses GuaranteePayment::setNonRefundableIndicator()
     * @uses GuaranteePayment::setPolicyCode()
     * @uses GuaranteePayment::setMon()
     * @uses GuaranteePayment::setTue()
     * @uses GuaranteePayment::setWeds()
     * @uses GuaranteePayment::setThur()
     * @uses GuaranteePayment::setFri()
     * @uses GuaranteePayment::setSat()
     * @uses GuaranteePayment::setSun()
     * @uses GuaranteePayment::setStart()
     * @uses GuaranteePayment::setDuration()
     * @uses GuaranteePayment::setEnd()
     * @param string $detailType
     * @param string $guaranteeType
     * @param \StructType\AcceptedPaymentsType $acceptedPayments
     * @param \StructType\AmountPercent $amountPercent
     * @param \StructType\Deadline[] $deadline
     * @param \StructType\ParagraphType[] $description
     * @param \StructType\Address[] $address
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $retributionType
     * @param string $paymentCode
     * @param string $type
     * @param string $guaranteeCode
     * @param string $holdTime
     * @param bool $noCardHolderInfoReqInd
     * @param bool $nameInd
     * @param bool $addressInd
     * @param bool $phoneInd
     * @param bool $interbankNbrInd
     * @param string $roomTypeCode
     * @param string $infoSource
     * @param bool $nonRefundableIndicator
     * @param string $policyCode
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct($detailType = null, $guaranteeType = null, \StructType\AcceptedPaymentsType $acceptedPayments = null, \StructType\AmountPercent $amountPercent = null, array $deadline = array(), array $description = array(), array $address = array(), \StructType\TPA_ExtensionsType $tPA_Extensions = null, $retributionType = null, $paymentCode = null, $type = null, $guaranteeCode = null, $holdTime = null, $noCardHolderInfoReqInd = null, $nameInd = null, $addressInd = null, $phoneInd = null, $interbankNbrInd = null, $roomTypeCode = null, $infoSource = null, $nonRefundableIndicator = null, $policyCode = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setDetailType($detailType)
            ->setGuaranteeType($guaranteeType)
            ->setAcceptedPayments($acceptedPayments)
            ->setAmountPercent($amountPercent)
            ->setDeadline($deadline)
            ->setDescription($description)
            ->setAddress($address)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRetributionType($retributionType)
            ->setPaymentCode($paymentCode)
            ->setType($type)
            ->setGuaranteeCode($guaranteeCode)
            ->setHoldTime($holdTime)
            ->setNoCardHolderInfoReqInd($noCardHolderInfoReqInd)
            ->setNameInd($nameInd)
            ->setAddressInd($addressInd)
            ->setPhoneInd($phoneInd)
            ->setInterbankNbrInd($interbankNbrInd)
            ->setRoomTypeCode($roomTypeCode)
            ->setInfoSource($infoSource)
            ->setNonRefundableIndicator($nonRefundableIndicator)
            ->setPolicyCode($policyCode)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get DetailType value
     * @return string|null
     */
    public function getDetailType()
    {
        return $this->DetailType;
    }
    /**
     * Set DetailType value
     * @param string $detailType
     * @return \StructType\GuaranteePayment
     */
    public function setDetailType($detailType = null)
    {
        // validation for constraint: string
        if (!is_null($detailType) && !is_string($detailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailType, true), gettype($detailType)), __LINE__);
        }
        $this->DetailType = $detailType;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \StructType\GuaranteePayment
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeType) && !is_string($guaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeType, true), gettype($guaranteeType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($guaranteeType) && mb_strlen($guaranteeType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($guaranteeType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($guaranteeType) && mb_strlen($guaranteeType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($guaranteeType)), __LINE__);
        }
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get AcceptedPayments value
     * @return \StructType\AcceptedPaymentsType|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param \StructType\AcceptedPaymentsType $acceptedPayments
     * @return \StructType\GuaranteePayment
     */
    public function setAcceptedPayments(\StructType\AcceptedPaymentsType $acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return \StructType\AmountPercent|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \StructType\AmountPercent $amountPercent
     * @return \StructType\GuaranteePayment
     */
    public function setAmountPercent(\StructType\AmountPercent $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline[]|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * This method is responsible for validating the values passed to the setDeadline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeadline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeadlineForArrayConstraintsFromSetDeadline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentDeadlineItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentDeadlineItem instanceof \StructType\Deadline) {
                $invalidValues[] = is_object($guaranteePaymentDeadlineItem) ? get_class($guaranteePaymentDeadlineItem) : sprintf('%s(%s)', gettype($guaranteePaymentDeadlineItem), var_export($guaranteePaymentDeadlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline[] $deadline
     * @return \StructType\GuaranteePayment
     */
    public function setDeadline(array $deadline = array())
    {
        // validation for constraint: array
        if ('' !== ($deadlineArrayErrorMessage = self::validateDeadlineForArrayConstraintsFromSetDeadline($deadline))) {
            throw new \InvalidArgumentException($deadlineArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($deadline) && count($deadline) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($deadline)), __LINE__);
        }
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Add item to Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline $item
     * @return \StructType\GuaranteePayment
     */
    public function addToDeadline(\StructType\Deadline $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Deadline) {
            throw new \InvalidArgumentException(sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Deadline) && count($this->Deadline) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Deadline)), __LINE__);
        }
        $this->Deadline[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentDescriptionItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($guaranteePaymentDescriptionItem) ? get_class($guaranteePaymentDescriptionItem) : sprintf('%s(%s)', gettype($guaranteePaymentDescriptionItem), var_export($guaranteePaymentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $description
     * @return \StructType\GuaranteePayment
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\GuaranteePayment
     */
    public function addToDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentAddressItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($guaranteePaymentAddressItem) ? get_class($guaranteePaymentAddressItem) : sprintf('%s(%s)', gettype($guaranteePaymentAddressItem), var_export($guaranteePaymentAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\GuaranteePayment
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($address) && count($address) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\GuaranteePayment
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Address) && count($this->Address) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\GuaranteePayment
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RetributionType value
     * @return string|null
     */
    public function getRetributionType()
    {
        return $this->RetributionType;
    }
    /**
     * Set RetributionType value
     * @param string $retributionType
     * @return \StructType\GuaranteePayment
     */
    public function setRetributionType($retributionType = null)
    {
        // validation for constraint: string
        if (!is_null($retributionType) && !is_string($retributionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retributionType, true), gettype($retributionType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($retributionType) && mb_strlen($retributionType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($retributionType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($retributionType) && mb_strlen($retributionType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($retributionType)), __LINE__);
        }
        $this->RetributionType = $retributionType;
        return $this;
    }
    /**
     * Get PaymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->PaymentCode;
    }
    /**
     * Set PaymentCode value
     * @param string $paymentCode
     * @return \StructType\GuaranteePayment
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCode, true), gettype($paymentCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($paymentCode) && mb_strlen($paymentCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($paymentCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($paymentCode) && mb_strlen($paymentCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($paymentCode)), __LINE__);
        }
        $this->PaymentCode = $paymentCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\GuaranteePayment
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get GuaranteeCode value
     * @return string|null
     */
    public function getGuaranteeCode()
    {
        return $this->GuaranteeCode;
    }
    /**
     * Set GuaranteeCode value
     * @param string $guaranteeCode
     * @return \StructType\GuaranteePayment
     */
    public function setGuaranteeCode($guaranteeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeCode) && !is_string($guaranteeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeCode, true), gettype($guaranteeCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($guaranteeCode) && mb_strlen($guaranteeCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($guaranteeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($guaranteeCode) && mb_strlen($guaranteeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($guaranteeCode)), __LINE__);
        }
        $this->GuaranteeCode = $guaranteeCode;
        return $this;
    }
    /**
     * Get HoldTime value
     * @return string|null
     */
    public function getHoldTime()
    {
        return $this->HoldTime;
    }
    /**
     * Set HoldTime value
     * @param string $holdTime
     * @return \StructType\GuaranteePayment
     */
    public function setHoldTime($holdTime = null)
    {
        // validation for constraint: string
        if (!is_null($holdTime) && !is_string($holdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdTime, true), gettype($holdTime)), __LINE__);
        }
        $this->HoldTime = $holdTime;
        return $this;
    }
    /**
     * Get NoCardHolderInfoReqInd value
     * @return bool|null
     */
    public function getNoCardHolderInfoReqInd()
    {
        return $this->NoCardHolderInfoReqInd;
    }
    /**
     * Set NoCardHolderInfoReqInd value
     * @param bool $noCardHolderInfoReqInd
     * @return \StructType\GuaranteePayment
     */
    public function setNoCardHolderInfoReqInd($noCardHolderInfoReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noCardHolderInfoReqInd) && !is_bool($noCardHolderInfoReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noCardHolderInfoReqInd, true), gettype($noCardHolderInfoReqInd)), __LINE__);
        }
        $this->NoCardHolderInfoReqInd = $noCardHolderInfoReqInd;
        return $this;
    }
    /**
     * Get NameInd value
     * @return bool|null
     */
    public function getNameInd()
    {
        return $this->NameInd;
    }
    /**
     * Set NameInd value
     * @param bool $nameInd
     * @return \StructType\GuaranteePayment
     */
    public function setNameInd($nameInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nameInd) && !is_bool($nameInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nameInd, true), gettype($nameInd)), __LINE__);
        }
        $this->NameInd = $nameInd;
        return $this;
    }
    /**
     * Get AddressInd value
     * @return bool|null
     */
    public function getAddressInd()
    {
        return $this->AddressInd;
    }
    /**
     * Set AddressInd value
     * @param bool $addressInd
     * @return \StructType\GuaranteePayment
     */
    public function setAddressInd($addressInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressInd) && !is_bool($addressInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressInd, true), gettype($addressInd)), __LINE__);
        }
        $this->AddressInd = $addressInd;
        return $this;
    }
    /**
     * Get PhoneInd value
     * @return bool|null
     */
    public function getPhoneInd()
    {
        return $this->PhoneInd;
    }
    /**
     * Set PhoneInd value
     * @param bool $phoneInd
     * @return \StructType\GuaranteePayment
     */
    public function setPhoneInd($phoneInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneInd) && !is_bool($phoneInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneInd, true), gettype($phoneInd)), __LINE__);
        }
        $this->PhoneInd = $phoneInd;
        return $this;
    }
    /**
     * Get InterbankNbrInd value
     * @return bool|null
     */
    public function getInterbankNbrInd()
    {
        return $this->InterbankNbrInd;
    }
    /**
     * Set InterbankNbrInd value
     * @param bool $interbankNbrInd
     * @return \StructType\GuaranteePayment
     */
    public function setInterbankNbrInd($interbankNbrInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($interbankNbrInd) && !is_bool($interbankNbrInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interbankNbrInd, true), gettype($interbankNbrInd)), __LINE__);
        }
        $this->InterbankNbrInd = $interbankNbrInd;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\GuaranteePayment
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomTypeCode) && mb_strlen($roomTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\GuaranteePayment
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($infoSource) && mb_strlen($infoSource) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($infoSource)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($infoSource) && mb_strlen($infoSource) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get NonRefundableIndicator value
     * @return bool|null
     */
    public function getNonRefundableIndicator()
    {
        return $this->NonRefundableIndicator;
    }
    /**
     * Set NonRefundableIndicator value
     * @param bool $nonRefundableIndicator
     * @return \StructType\GuaranteePayment
     */
    public function setNonRefundableIndicator($nonRefundableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableIndicator) && !is_bool($nonRefundableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundableIndicator, true), gettype($nonRefundableIndicator)), __LINE__);
        }
        $this->NonRefundableIndicator = $nonRefundableIndicator;
        return $this;
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \StructType\GuaranteePayment
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyCode, true), gettype($policyCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($policyCode) && mb_strlen($policyCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($policyCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($policyCode) && mb_strlen($policyCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \StructType\GuaranteePayment
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \StructType\GuaranteePayment
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \StructType\GuaranteePayment
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \StructType\GuaranteePayment
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \StructType\GuaranteePayment
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \StructType\GuaranteePayment
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \StructType\GuaranteePayment
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\GuaranteePayment
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\GuaranteePayment
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\GuaranteePayment
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuaranteePayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
