<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FuelLevelDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: This provides a specifc amount of fuel (e.g. 10 gallons). | This provides values based on the amount of fuel present.
 * @subpackage Structs
 */
class FuelLevelDetails extends AbstractStructBase
{
    /**
     * The FuelLevelValue
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FuelLevelValue;
    /**
     * The UnitOfMeasureQuantity
     * @var float
     */
    public $UnitOfMeasureQuantity;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * Constructor method for FuelLevelDetails
     * @uses FuelLevelDetails::setFuelLevelValue()
     * @uses FuelLevelDetails::setUnitOfMeasureQuantity()
     * @uses FuelLevelDetails::setUnitOfMeasure()
     * @uses FuelLevelDetails::setUnitOfMeasureCode()
     * @param string $fuelLevelValue
     * @param float $unitOfMeasureQuantity
     * @param string $unitOfMeasure
     * @param string $unitOfMeasureCode
     */
    public function __construct($fuelLevelValue = null, $unitOfMeasureQuantity = null, $unitOfMeasure = null, $unitOfMeasureCode = null)
    {
        $this
            ->setFuelLevelValue($fuelLevelValue)
            ->setUnitOfMeasureQuantity($unitOfMeasureQuantity)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setUnitOfMeasureCode($unitOfMeasureCode);
    }
    /**
     * Get FuelLevelValue value
     * @return string|null
     */
    public function getFuelLevelValue()
    {
        return $this->FuelLevelValue;
    }
    /**
     * Set FuelLevelValue value
     * @param string $fuelLevelValue
     * @return \StructType\FuelLevelDetails
     */
    public function setFuelLevelValue($fuelLevelValue = null)
    {
        // validation for constraint: string
        if (!is_null($fuelLevelValue) && !is_string($fuelLevelValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fuelLevelValue, true), gettype($fuelLevelValue)), __LINE__);
        }
        $this->FuelLevelValue = $fuelLevelValue;
        return $this;
    }
    /**
     * Get UnitOfMeasureQuantity value
     * @return float|null
     */
    public function getUnitOfMeasureQuantity()
    {
        return $this->UnitOfMeasureQuantity;
    }
    /**
     * Set UnitOfMeasureQuantity value
     * @param float $unitOfMeasureQuantity
     * @return \StructType\FuelLevelDetails
     */
    public function setUnitOfMeasureQuantity($unitOfMeasureQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($unitOfMeasureQuantity) && !(is_float($unitOfMeasureQuantity) || is_numeric($unitOfMeasureQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitOfMeasureQuantity, true), gettype($unitOfMeasureQuantity)), __LINE__);
        }
        $this->UnitOfMeasureQuantity = $unitOfMeasureQuantity;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\FuelLevelDetails
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\FuelLevelDetails
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unitOfMeasureCode, true)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FuelLevelDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
