<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRestrictionPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify a fare restriction and the preference level for the restriction. | Constrains the pricing to those fares with restrictions that satisfy user-imposed limitations.
 * @subpackage Structs
 */
class FareRestrictionPref extends AbstractStructBase
{
    /**
     * The FareRestriction
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Fare Restriction (FAR). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $FareRestriction;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: A date that is associated to the fare restriction. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $Date;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for FareRestrictionPref
     * @uses FareRestrictionPref::setFareRestriction()
     * @uses FareRestrictionPref::setDate()
     * @uses FareRestrictionPref::setPreferLevel()
     * @param string $fareRestriction
     * @param string $date
     * @param string $preferLevel
     */
    public function __construct($fareRestriction = null, $date = null, $preferLevel = null)
    {
        $this
            ->setFareRestriction($fareRestriction)
            ->setDate($date)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get FareRestriction value
     * @return string|null
     */
    public function getFareRestriction()
    {
        return $this->FareRestriction;
    }
    /**
     * Set FareRestriction value
     * @param string $fareRestriction
     * @return \StructType\FareRestrictionPref
     */
    public function setFareRestriction($fareRestriction = null)
    {
        // validation for constraint: string
        if (!is_null($fareRestriction) && !is_string($fareRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRestriction, true), gettype($fareRestriction)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($fareRestriction) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $fareRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($fareRestriction, true)), __LINE__);
        }
        $this->FareRestriction = $fareRestriction;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the value passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForUnionConstraintsFromSetDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\FareRestrictionPref
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($dateUnionErrorMessage = self::validateDateForUnionConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateUnionErrorMessage, __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\FareRestrictionPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareRestrictionPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
