<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRestrictPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Container used for specifying or limiting acceptable fare restrictions. | Constrains a fare search to those with restrictions that satisfy user-imposed limitations. | Indicates preferred fare restrictions to be used in search.
 * @subpackage Structs
 */
class FareRestrictPref extends AbstractStructBase
{
    /**
     * The FareRestriction
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $FareRestriction;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $Date;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * The AdvResTicketing
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether advance reservation or ticketing restrictions are acceptable in the search results.
     * - minOccurs: 0
     * @var \StructType\AdvResTicketingType
     */
    public $AdvResTicketing;
    /**
     * The StayRestrictions
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether restrictions on minimum or maximum stays should be included in the search results.
     * - minOccurs: 0
     * @var \StructType\StayRestrictionsType
     */
    public $StayRestrictions;
    /**
     * The VoluntaryChanges
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether penalties associated with voluntary changes should be included in the search results.
     * - minOccurs: 0
     * @var \StructType\VoluntaryChangesType
     */
    public $VoluntaryChanges;
    /**
     * The FareDisplayCurrency
     * Meta information extracted from the WSDL
     * - documentation: Currency in which fare display is requested. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $FareDisplayCurrency;
    /**
     * The CurrencyOverride
     * Meta information extracted from the WSDL
     * - documentation: Display fare published in other than local selling currency only. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $CurrencyOverride;
    /**
     * Constructor method for FareRestrictPref
     * @uses FareRestrictPref::setFareRestriction()
     * @uses FareRestrictPref::setDate()
     * @uses FareRestrictPref::setPreferLevel()
     * @uses FareRestrictPref::setAdvResTicketing()
     * @uses FareRestrictPref::setStayRestrictions()
     * @uses FareRestrictPref::setVoluntaryChanges()
     * @uses FareRestrictPref::setFareDisplayCurrency()
     * @uses FareRestrictPref::setCurrencyOverride()
     * @param string $fareRestriction
     * @param string $date
     * @param string $preferLevel
     * @param \StructType\AdvResTicketingType $advResTicketing
     * @param \StructType\StayRestrictionsType $stayRestrictions
     * @param \StructType\VoluntaryChangesType $voluntaryChanges
     * @param string $fareDisplayCurrency
     * @param string $currencyOverride
     */
    public function __construct($fareRestriction = null, $date = null, $preferLevel = null, \StructType\AdvResTicketingType $advResTicketing = null, \StructType\StayRestrictionsType $stayRestrictions = null, \StructType\VoluntaryChangesType $voluntaryChanges = null, $fareDisplayCurrency = null, $currencyOverride = null)
    {
        $this
            ->setFareRestriction($fareRestriction)
            ->setDate($date)
            ->setPreferLevel($preferLevel)
            ->setAdvResTicketing($advResTicketing)
            ->setStayRestrictions($stayRestrictions)
            ->setVoluntaryChanges($voluntaryChanges)
            ->setFareDisplayCurrency($fareDisplayCurrency)
            ->setCurrencyOverride($currencyOverride);
    }
    /**
     * Get FareRestriction value
     * @return string|null
     */
    public function getFareRestriction()
    {
        return $this->FareRestriction;
    }
    /**
     * Set FareRestriction value
     * @param string $fareRestriction
     * @return \StructType\FareRestrictPref
     */
    public function setFareRestriction($fareRestriction = null)
    {
        // validation for constraint: string
        if (!is_null($fareRestriction) && !is_string($fareRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRestriction, true), gettype($fareRestriction)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($fareRestriction) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $fareRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($fareRestriction, true)), __LINE__);
        }
        $this->FareRestriction = $fareRestriction;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the value passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForUnionConstraintsFromSetDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\FareRestrictPref
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($dateUnionErrorMessage = self::validateDateForUnionConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateUnionErrorMessage, __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\FareRestrictPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get AdvResTicketing value
     * @return \StructType\AdvResTicketingType|null
     */
    public function getAdvResTicketing()
    {
        return $this->AdvResTicketing;
    }
    /**
     * Set AdvResTicketing value
     * @param \StructType\AdvResTicketingType $advResTicketing
     * @return \StructType\FareRestrictPref
     */
    public function setAdvResTicketing(\StructType\AdvResTicketingType $advResTicketing = null)
    {
        $this->AdvResTicketing = $advResTicketing;
        return $this;
    }
    /**
     * Get StayRestrictions value
     * @return \StructType\StayRestrictionsType|null
     */
    public function getStayRestrictions()
    {
        return $this->StayRestrictions;
    }
    /**
     * Set StayRestrictions value
     * @param \StructType\StayRestrictionsType $stayRestrictions
     * @return \StructType\FareRestrictPref
     */
    public function setStayRestrictions(\StructType\StayRestrictionsType $stayRestrictions = null)
    {
        $this->StayRestrictions = $stayRestrictions;
        return $this;
    }
    /**
     * Get VoluntaryChanges value
     * @return \StructType\VoluntaryChangesType|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param \StructType\VoluntaryChangesType $voluntaryChanges
     * @return \StructType\FareRestrictPref
     */
    public function setVoluntaryChanges(\StructType\VoluntaryChangesType $voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
    /**
     * Get FareDisplayCurrency value
     * @return string|null
     */
    public function getFareDisplayCurrency()
    {
        return $this->FareDisplayCurrency;
    }
    /**
     * Set FareDisplayCurrency value
     * @param string $fareDisplayCurrency
     * @return \StructType\FareRestrictPref
     */
    public function setFareDisplayCurrency($fareDisplayCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($fareDisplayCurrency) && !is_string($fareDisplayCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareDisplayCurrency, true), gettype($fareDisplayCurrency)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($fareDisplayCurrency) && !preg_match('/[a-zA-Z]{3}/', $fareDisplayCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($fareDisplayCurrency, true)), __LINE__);
        }
        $this->FareDisplayCurrency = $fareDisplayCurrency;
        return $this;
    }
    /**
     * Get CurrencyOverride value
     * @return string|null
     */
    public function getCurrencyOverride()
    {
        return $this->CurrencyOverride;
    }
    /**
     * Set CurrencyOverride value
     * @param string $currencyOverride
     * @return \StructType\FareRestrictPref
     */
    public function setCurrencyOverride($currencyOverride = null)
    {
        // validation for constraint: string
        if (!is_null($currencyOverride) && !is_string($currencyOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyOverride, true), gettype($currencyOverride)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyOverride) && !preg_match('/[a-zA-Z]{3}/', $currencyOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyOverride, true)), __LINE__);
        }
        $this->CurrencyOverride = $currencyOverride;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareRestrictPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
