<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponent StructType
 * Meta information extracted from the WSDL
 * - documentation: The currency code and the amount for the fare component. | Provides the data for a component of the fare.
 * @subpackage Structs
 */
class FareComponent extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: The fare component number. | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The FlightLeg
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\FlightLeg[]
     */
    public $FlightLeg;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for FareComponent
     * @uses FareComponent::setNumber()
     * @uses FareComponent::setFlightLeg()
     * @uses FareComponent::setAmount()
     * @uses FareComponent::setCurrencyCode()
     * @uses FareComponent::setDecimalPlaces()
     * @param int $number
     * @param \StructType\FlightLeg[] $flightLeg
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($number = null, array $flightLeg = array(), $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setNumber($number)
            ->setFlightLeg($flightLeg)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\FareComponent
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($number) && $number > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($number) && $number < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($number, true)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get FlightLeg value
     * @return \StructType\FlightLeg[]|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightLeg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightLeg method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightLegForArrayConstraintsFromSetFlightLeg(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentFlightLegItem) {
            // validation for constraint: itemType
            if (!$fareComponentFlightLegItem instanceof \StructType\FlightLeg) {
                $invalidValues[] = is_object($fareComponentFlightLegItem) ? get_class($fareComponentFlightLegItem) : sprintf('%s(%s)', gettype($fareComponentFlightLegItem), var_export($fareComponentFlightLegItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightLeg property can only contain items of type \StructType\FlightLeg, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightLeg value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLeg[] $flightLeg
     * @return \StructType\FareComponent
     */
    public function setFlightLeg(array $flightLeg = array())
    {
        // validation for constraint: array
        if ('' !== ($flightLegArrayErrorMessage = self::validateFlightLegForArrayConstraintsFromSetFlightLeg($flightLeg))) {
            throw new \InvalidArgumentException($flightLegArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($flightLeg) && count($flightLeg) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($flightLeg)), __LINE__);
        }
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Add item to FlightLeg value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLeg $item
     * @return \StructType\FareComponent
     */
    public function addToFlightLeg(\StructType\FlightLeg $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightLeg) {
            throw new \InvalidArgumentException(sprintf('The FlightLeg property can only contain items of type \StructType\FlightLeg, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FlightLeg) && count($this->FlightLeg) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FlightLeg)), __LINE__);
        }
        $this->FlightLeg[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\FareComponent
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\FareComponent
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\FareComponent
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
