<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBaggageAllowance StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage allowance for this fare. | Checked baggage allowance for the fare.
 * @subpackage Structs
 */
class FareBaggageAllowance extends AbstractStructBase
{
    /**
     * The FlightSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: The segment this baggage allowance is associated with. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $FlightSegmentRPH;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The UnitOfMeasureQuantity
     * @var float
     */
    public $UnitOfMeasureQuantity;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * Constructor method for FareBaggageAllowance
     * @uses FareBaggageAllowance::setFlightSegmentRPH()
     * @uses FareBaggageAllowance::setOperation()
     * @uses FareBaggageAllowance::setUnitOfMeasureQuantity()
     * @uses FareBaggageAllowance::setUnitOfMeasure()
     * @uses FareBaggageAllowance::setUnitOfMeasureCode()
     * @param string $flightSegmentRPH
     * @param string $operation
     * @param float $unitOfMeasureQuantity
     * @param string $unitOfMeasure
     * @param string $unitOfMeasureCode
     */
    public function __construct($flightSegmentRPH = null, $operation = null, $unitOfMeasureQuantity = null, $unitOfMeasure = null, $unitOfMeasureCode = null)
    {
        $this
            ->setFlightSegmentRPH($flightSegmentRPH)
            ->setOperation($operation)
            ->setUnitOfMeasureQuantity($unitOfMeasureQuantity)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setUnitOfMeasureCode($unitOfMeasureCode);
    }
    /**
     * Get FlightSegmentRPH value
     * @return string|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * Set FlightSegmentRPH value
     * @param string $flightSegmentRPH
     * @return \StructType\FareBaggageAllowance
     */
    public function setFlightSegmentRPH($flightSegmentRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightSegmentRPH) && !is_string($flightSegmentRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightSegmentRPH, true), gettype($flightSegmentRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($flightSegmentRPH) && !preg_match('/[0-9]{1,8}/', $flightSegmentRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($flightSegmentRPH, true)), __LINE__);
        }
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\FareBaggageAllowance
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get UnitOfMeasureQuantity value
     * @return float|null
     */
    public function getUnitOfMeasureQuantity()
    {
        return $this->UnitOfMeasureQuantity;
    }
    /**
     * Set UnitOfMeasureQuantity value
     * @param float $unitOfMeasureQuantity
     * @return \StructType\FareBaggageAllowance
     */
    public function setUnitOfMeasureQuantity($unitOfMeasureQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($unitOfMeasureQuantity) && !(is_float($unitOfMeasureQuantity) || is_numeric($unitOfMeasureQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitOfMeasureQuantity, true), gettype($unitOfMeasureQuantity)), __LINE__);
        }
        $this->UnitOfMeasureQuantity = $unitOfMeasureQuantity;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\FareBaggageAllowance
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\FareBaggageAllowance
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unitOfMeasureCode, true)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareBaggageAllowance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
