<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of the error. | Standard way to indicate that an error occurred during the processing of an OpenTravel message. If the message successfully processes, but there are business errors, those errors should be passed in the
 * warning element.
 * @subpackage Structs
 */
class ErrorType extends FreeTextType
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The Error element MUST contain the Type attribute that uses a recommended set of values to indicate the error type. The validating XSD can expect to accept values that it has NOT been explicitly coded for and process them by using
     * Type ="Unknown". Refer to OpenTravel Code List Error Warning Type (EWT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The _
     * @var \StructType\FreeTextType
     */
    public $_;
    /**
     * The NodeList
     * Meta information extracted from the WSDL
     * - documentation: An XPath expression that selects all the nodes whose data caused this error. Further, this expression should have an additional contraint which contains the data of the node. This will provide the offending data back to systems that
     * cannot maintain the original message.
     * - use: optional
     * @var string
     */
    public $NodeList;
    /**
     * The ShortText
     * Meta information extracted from the WSDL
     * - documentation: An abbreviated version of the error in textual format. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: If present, this refers to a table of coded values exchanged between applications to identify errors or warnings. Refer to OpenTravel Code List Error Codes (ERR). | Used for codes in the OpenTravel Code tables. Possible values of
     * this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The DocURL
     * Meta information extracted from the WSDL
     * - documentation: If present, this URL refers to an online description of the error that occurred.
     * - type: xs:anyURI
     * - use: optional
     * @var string
     */
    public $DocURL;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: If present, recommended values are those enumerated in the OTA_ErrorRS, (NotProcessed | Incomplete | Complete | Unknown) however, the data type is designated as string data, recognizing that trading partners may identify additional
     * status conditions not included in the enumeration. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - documentation: If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one
     * tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Tag;
    /**
     * The RecordID
     * Meta information extracted from the WSDL
     * - documentation: If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s)
     * associated with that transaction. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RecordID;
    /**
     * Constructor method for ErrorType
     * @uses ErrorType::setType()
     * @uses ErrorType::set_()
     * @uses ErrorType::setNodeList()
     * @uses ErrorType::setShortText()
     * @uses ErrorType::setCode()
     * @uses ErrorType::setDocURL()
     * @uses ErrorType::setStatus()
     * @uses ErrorType::setTag()
     * @uses ErrorType::setRecordID()
     * @param string $type
     * @param \StructType\FreeTextType $_
     * @param string $nodeList
     * @param string $shortText
     * @param string $code
     * @param string $docURL
     * @param string $status
     * @param string $tag
     * @param string $recordID
     */
    public function __construct($type = null, \StructType\FreeTextType $_ = null, $nodeList = null, $shortText = null, $code = null, $docURL = null, $status = null, $tag = null, $recordID = null)
    {
        $this
            ->setType($type)
            ->set_($_)
            ->setNodeList($nodeList)
            ->setShortText($shortText)
            ->setCode($code)
            ->setDocURL($docURL)
            ->setStatus($status)
            ->setTag($tag)
            ->setRecordID($recordID);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ErrorType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get _ value
     * @return \StructType\FreeTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\FreeTextType $_
     * @return \StructType\ErrorType
     */
    public function set_(\StructType\FreeTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get NodeList value
     * @return string|null
     */
    public function getNodeList()
    {
        return $this->NodeList;
    }
    /**
     * Set NodeList value
     * @param string $nodeList
     * @return \StructType\ErrorType
     */
    public function setNodeList($nodeList = null)
    {
        // validation for constraint: string
        if (!is_null($nodeList) && !is_string($nodeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nodeList, true), gettype($nodeList)), __LINE__);
        }
        $this->NodeList = $nodeList;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \StructType\ErrorType
     */
    public function setShortText($shortText = null)
    {
        // validation for constraint: string
        if (!is_null($shortText) && !is_string($shortText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortText, true), gettype($shortText)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($shortText) && mb_strlen($shortText) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($shortText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($shortText) && mb_strlen($shortText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($shortText)), __LINE__);
        }
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ErrorType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($code) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($code, true)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DocURL value
     * @return string|null
     */
    public function getDocURL()
    {
        return $this->DocURL;
    }
    /**
     * Set DocURL value
     * @param string $docURL
     * @return \StructType\ErrorType
     */
    public function setDocURL($docURL = null)
    {
        // validation for constraint: string
        if (!is_null($docURL) && !is_string($docURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docURL, true), gettype($docURL)), __LINE__);
        }
        $this->DocURL = $docURL;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ErrorType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($status) && mb_strlen($status) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($status) && mb_strlen($status) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @param string $tag
     * @return \StructType\ErrorType
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tag, true), gettype($tag)), __LINE__);
        }
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \StructType\ErrorType
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordID, true), gettype($recordID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($recordID) && mb_strlen($recordID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($recordID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($recordID) && mb_strlen($recordID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ErrorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
