<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the aircraft equipment type. | Used for Character Strings, length 0 to 64.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class EquipmentType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The AirEquipType
     * Meta information extracted from the WSDL
     * - documentation: This is the 3 character IATA code. | Used for Strings, length exactly 3.
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - use: optional
     * @var string
     */
    public $AirEquipType;
    /**
     * The ChangeofGauge
     * Meta information extracted from the WSDL
     * - documentation: false | Indicates there is an equipment change.
     * - use: optional
     * @var bool
     */
    public $ChangeofGauge;
    /**
     * Constructor method for EquipmentType
     * @uses EquipmentType::set_()
     * @uses EquipmentType::setAirEquipType()
     * @uses EquipmentType::setChangeofGauge()
     * @param string $_
     * @param string $airEquipType
     * @param bool $changeofGauge
     */
    public function __construct($_ = null, $airEquipType = null, $changeofGauge = null)
    {
        $this
            ->set_($_)
            ->setAirEquipType($airEquipType)
            ->setChangeofGauge($changeofGauge);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\EquipmentType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($_) && mb_strlen($_) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get AirEquipType value
     * @return string|null
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \StructType\EquipmentType
     */
    public function setAirEquipType($airEquipType = null)
    {
        // validation for constraint: string
        if (!is_null($airEquipType) && !is_string($airEquipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airEquipType, true), gettype($airEquipType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($airEquipType) && mb_strlen($airEquipType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($airEquipType)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($airEquipType) && mb_strlen($airEquipType) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($airEquipType)), __LINE__);
        }
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Get ChangeofGauge value
     * @return bool|null
     */
    public function getChangeofGauge()
    {
        return $this->ChangeofGauge;
    }
    /**
     * Set ChangeofGauge value
     * @param bool $changeofGauge
     * @return \StructType\EquipmentType
     */
    public function setChangeofGauge($changeofGauge = null)
    {
        // validation for constraint: boolean
        if (!is_null($changeofGauge) && !is_bool($changeofGauge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changeofGauge, true), gettype($changeofGauge)), __LINE__);
        }
        $this->ChangeofGauge = $changeofGauge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EquipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
