<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Endorsements StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for endorsements.
 * @subpackage Structs
 */
class Endorsements extends AbstractStructBase
{
    /**
     * The Endorsement
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\Endorsement[]
     */
    public $Endorsement;
    /**
     * The NonRefundableIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the ticket is refundable. If true, the ticket is NOT refundable.
     * - use: optional
     * @var bool
     */
    public $NonRefundableIndicator;
    /**
     * The NonEndorsableIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the ticket is endorsable. If true, the ticket is NOT endorsable.
     * - use: optional
     * @var bool
     */
    public $NonEndorsableIndicator;
    /**
     * Constructor method for Endorsements
     * @uses Endorsements::setEndorsement()
     * @uses Endorsements::setNonRefundableIndicator()
     * @uses Endorsements::setNonEndorsableIndicator()
     * @param \StructType\Endorsement[] $endorsement
     * @param bool $nonRefundableIndicator
     * @param bool $nonEndorsableIndicator
     */
    public function __construct(array $endorsement = array(), $nonRefundableIndicator = null, $nonEndorsableIndicator = null)
    {
        $this
            ->setEndorsement($endorsement)
            ->setNonRefundableIndicator($nonRefundableIndicator)
            ->setNonEndorsableIndicator($nonEndorsableIndicator);
    }
    /**
     * Get Endorsement value
     * @return \StructType\Endorsement[]|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * This method is responsible for validating the values passed to the setEndorsement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndorsement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndorsementForArrayConstraintsFromSetEndorsement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $endorsementsEndorsementItem) {
            // validation for constraint: itemType
            if (!$endorsementsEndorsementItem instanceof \StructType\Endorsement) {
                $invalidValues[] = is_object($endorsementsEndorsementItem) ? get_class($endorsementsEndorsementItem) : sprintf('%s(%s)', gettype($endorsementsEndorsementItem), var_export($endorsementsEndorsementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Endorsement property can only contain items of type \StructType\Endorsement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Endorsement value
     * @throws \InvalidArgumentException
     * @param \StructType\Endorsement[] $endorsement
     * @return \StructType\Endorsements
     */
    public function setEndorsement(array $endorsement = array())
    {
        // validation for constraint: array
        if ('' !== ($endorsementArrayErrorMessage = self::validateEndorsementForArrayConstraintsFromSetEndorsement($endorsement))) {
            throw new \InvalidArgumentException($endorsementArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($endorsement) && count($endorsement) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($endorsement)), __LINE__);
        }
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Add item to Endorsement value
     * @throws \InvalidArgumentException
     * @param \StructType\Endorsement $item
     * @return \StructType\Endorsements
     */
    public function addToEndorsement(\StructType\Endorsement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Endorsement) {
            throw new \InvalidArgumentException(sprintf('The Endorsement property can only contain items of type \StructType\Endorsement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Endorsement) && count($this->Endorsement) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Endorsement)), __LINE__);
        }
        $this->Endorsement[] = $item;
        return $this;
    }
    /**
     * Get NonRefundableIndicator value
     * @return bool|null
     */
    public function getNonRefundableIndicator()
    {
        return $this->NonRefundableIndicator;
    }
    /**
     * Set NonRefundableIndicator value
     * @param bool $nonRefundableIndicator
     * @return \StructType\Endorsements
     */
    public function setNonRefundableIndicator($nonRefundableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableIndicator) && !is_bool($nonRefundableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundableIndicator, true), gettype($nonRefundableIndicator)), __LINE__);
        }
        $this->NonRefundableIndicator = $nonRefundableIndicator;
        return $this;
    }
    /**
     * Get NonEndorsableIndicator value
     * @return bool|null
     */
    public function getNonEndorsableIndicator()
    {
        return $this->NonEndorsableIndicator;
    }
    /**
     * Set NonEndorsableIndicator value
     * @param bool $nonEndorsableIndicator
     * @return \StructType\Endorsements
     */
    public function setNonEndorsableIndicator($nonEndorsableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonEndorsableIndicator) && !is_bool($nonEndorsableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonEndorsableIndicator, true), gettype($nonEndorsableIndicator)), __LINE__);
        }
        $this->NonEndorsableIndicator = $nonEndorsableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Endorsements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
