<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndDateWindow StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies a date range. | The earliest and latest dates acceptable for the end date.
 * @subpackage Structs
 */
class EndDateWindow extends AbstractStructBase
{
    /**
     * The EarliestDate
     * Meta information extracted from the WSDL
     * - documentation: The earliest ending date/time for the availability requested, expressed in dateTime format as prescribed by ISO 8601. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $EarliestDate;
    /**
     * The LatestDate
     * Meta information extracted from the WSDL
     * - documentation: The latest ending date/time for the availability requested, expressed in dateTime format as prescribed by ISO 8601. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $LatestDate;
    /**
     * The DOW
     * Meta information extracted from the WSDL
     * - documentation: The Day of Week of the starting date for the availability requested. Enumerated values of StartDOW are the seven days of the week: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, or Sunday.
     * - type: DayOfWeekType
     * - use: optional
     * @var string
     */
    public $DOW;
    /**
     * Constructor method for EndDateWindow
     * @uses EndDateWindow::setEarliestDate()
     * @uses EndDateWindow::setLatestDate()
     * @uses EndDateWindow::setDOW()
     * @param string $earliestDate
     * @param string $latestDate
     * @param string $dOW
     */
    public function __construct($earliestDate = null, $latestDate = null, $dOW = null)
    {
        $this
            ->setEarliestDate($earliestDate)
            ->setLatestDate($latestDate)
            ->setDOW($dOW);
    }
    /**
     * Get EarliestDate value
     * @return string|null
     */
    public function getEarliestDate()
    {
        return $this->EarliestDate;
    }
    /**
     * This method is responsible for validating the value passed to the setEarliestDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEarliestDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setEarliestDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEarliestDateForUnionConstraintsFromSetEarliestDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set EarliestDate value
     * @param string $earliestDate
     * @return \StructType\EndDateWindow
     */
    public function setEarliestDate($earliestDate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestDate) && !is_string($earliestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestDate, true), gettype($earliestDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($earliestDateUnionErrorMessage = self::validateEarliestDateForUnionConstraintsFromSetEarliestDate($earliestDate))) {
            throw new \InvalidArgumentException($earliestDateUnionErrorMessage, __LINE__);
        }
        $this->EarliestDate = $earliestDate;
        return $this;
    }
    /**
     * Get LatestDate value
     * @return string|null
     */
    public function getLatestDate()
    {
        return $this->LatestDate;
    }
    /**
     * This method is responsible for validating the value passed to the setLatestDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLatestDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setLatestDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLatestDateForUnionConstraintsFromSetLatestDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set LatestDate value
     * @param string $latestDate
     * @return \StructType\EndDateWindow
     */
    public function setLatestDate($latestDate = null)
    {
        // validation for constraint: string
        if (!is_null($latestDate) && !is_string($latestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestDate, true), gettype($latestDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($latestDateUnionErrorMessage = self::validateLatestDateForUnionConstraintsFromSetLatestDate($latestDate))) {
            throw new \InvalidArgumentException($latestDateUnionErrorMessage, __LINE__);
        }
        $this->LatestDate = $latestDate;
        return $this;
    }
    /**
     * Get DOW value
     * @return string|null
     */
    public function getDOW()
    {
        return $this->DOW;
    }
    /**
     * Set DOW value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dOW
     * @return \StructType\EndDateWindow
     */
    public function setDOW($dOW = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($dOW)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($dOW) ? implode(', ', $dOW) : var_export($dOW, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DOW = $dOW;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EndDateWindow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
