<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Employment identification; using an employee ID number, title, level within the company, and an indication of their status (e.g., active, retired, on leave, or terminated from employment). Additional information about an employee can
 * be entered into the element, including the name of the employee, if it differs from the person name identified as a customer or contact. | Used for Character Strings, length 0 to 64.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class EmployeeInfoType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The EmployeeId
     * Meta information extracted from the WSDL
     * - documentation: Identifier assigned to the employee. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $EmployeeId;
    /**
     * The EmployeeLevel
     * Meta information extracted from the WSDL
     * - documentation: Level in employer organization (e.g. seniority) that coveys privileges. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $EmployeeLevel;
    /**
     * The EmployeeTitle
     * Meta information extracted from the WSDL
     * - documentation: Title of employee in the employer company that conveys rank or privileges. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $EmployeeTitle;
    /**
     * The EmployeeStatus
     * Meta information extracted from the WSDL
     * - documentation: Status of employment. Refer to OpenTravel Code List Employee Status (EMP). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $EmployeeStatus;
    /**
     * Constructor method for EmployeeInfoType
     * @uses EmployeeInfoType::set_()
     * @uses EmployeeInfoType::setEmployeeId()
     * @uses EmployeeInfoType::setEmployeeLevel()
     * @uses EmployeeInfoType::setEmployeeTitle()
     * @uses EmployeeInfoType::setEmployeeStatus()
     * @param string $_
     * @param string $employeeId
     * @param string $employeeLevel
     * @param string $employeeTitle
     * @param string $employeeStatus
     */
    public function __construct($_ = null, $employeeId = null, $employeeLevel = null, $employeeTitle = null, $employeeStatus = null)
    {
        $this
            ->set_($_)
            ->setEmployeeId($employeeId)
            ->setEmployeeLevel($employeeLevel)
            ->setEmployeeTitle($employeeTitle)
            ->setEmployeeStatus($employeeStatus);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\EmployeeInfoType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($_) && mb_strlen($_) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get EmployeeId value
     * @return string|null
     */
    public function getEmployeeId()
    {
        return $this->EmployeeId;
    }
    /**
     * Set EmployeeId value
     * @param string $employeeId
     * @return \StructType\EmployeeInfoType
     */
    public function setEmployeeId($employeeId = null)
    {
        // validation for constraint: string
        if (!is_null($employeeId) && !is_string($employeeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeId, true), gettype($employeeId)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($employeeId) && mb_strlen($employeeId) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($employeeId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($employeeId) && mb_strlen($employeeId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($employeeId)), __LINE__);
        }
        $this->EmployeeId = $employeeId;
        return $this;
    }
    /**
     * Get EmployeeLevel value
     * @return string|null
     */
    public function getEmployeeLevel()
    {
        return $this->EmployeeLevel;
    }
    /**
     * Set EmployeeLevel value
     * @param string $employeeLevel
     * @return \StructType\EmployeeInfoType
     */
    public function setEmployeeLevel($employeeLevel = null)
    {
        // validation for constraint: string
        if (!is_null($employeeLevel) && !is_string($employeeLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeLevel, true), gettype($employeeLevel)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($employeeLevel) && mb_strlen($employeeLevel) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($employeeLevel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($employeeLevel) && mb_strlen($employeeLevel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($employeeLevel)), __LINE__);
        }
        $this->EmployeeLevel = $employeeLevel;
        return $this;
    }
    /**
     * Get EmployeeTitle value
     * @return string|null
     */
    public function getEmployeeTitle()
    {
        return $this->EmployeeTitle;
    }
    /**
     * Set EmployeeTitle value
     * @param string $employeeTitle
     * @return \StructType\EmployeeInfoType
     */
    public function setEmployeeTitle($employeeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($employeeTitle) && !is_string($employeeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeTitle, true), gettype($employeeTitle)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($employeeTitle) && mb_strlen($employeeTitle) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($employeeTitle)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($employeeTitle) && mb_strlen($employeeTitle) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($employeeTitle)), __LINE__);
        }
        $this->EmployeeTitle = $employeeTitle;
        return $this;
    }
    /**
     * Get EmployeeStatus value
     * @return string|null
     */
    public function getEmployeeStatus()
    {
        return $this->EmployeeStatus;
    }
    /**
     * Set EmployeeStatus value
     * @param string $employeeStatus
     * @return \StructType\EmployeeInfoType
     */
    public function setEmployeeStatus($employeeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($employeeStatus) && !is_string($employeeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeStatus, true), gettype($employeeStatus)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($employeeStatus) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $employeeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($employeeStatus, true)), __LINE__);
        }
        $this->EmployeeStatus = $employeeStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmployeeInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
