<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies and provides details about the discount.
 * @subpackage Structs
 */
class DiscountType extends TotalType
{
    /**
     * The DiscountReason
     * @var \StructType\ParagraphType
     */
    public $DiscountReason;
    /**
     * The TaxInclusive
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the type of discount (e.g., No condition, LOS, Deposit or Total amount spent). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DiscountCode;
    /**
     * The RestrictedDisplayIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, used to indicate the discount should not be displayed. When false, indicates the discount may be displayed.
     * - use: optional
     * @var bool
     */
    public $RestrictedDisplayIndicator;
    /**
     * Constructor method for DiscountType
     * @uses DiscountType::setDiscountReason()
     * @uses DiscountType::setTaxInclusive()
     * @uses DiscountType::setPercent()
     * @uses DiscountType::setDiscountCode()
     * @uses DiscountType::setRestrictedDisplayIndicator()
     * @param \StructType\ParagraphType $discountReason
     * @param bool $taxInclusive
     * @param float $percent
     * @param string $discountCode
     * @param bool $restrictedDisplayIndicator
     */
    public function __construct(\StructType\ParagraphType $discountReason = null, $taxInclusive = null, $percent = null, $discountCode = null, $restrictedDisplayIndicator = null)
    {
        $this
            ->setDiscountReason($discountReason)
            ->setTaxInclusive($taxInclusive)
            ->setPercent($percent)
            ->setDiscountCode($discountCode)
            ->setRestrictedDisplayIndicator($restrictedDisplayIndicator);
    }
    /**
     * Get DiscountReason value
     * @return \StructType\ParagraphType|null
     */
    public function getDiscountReason()
    {
        return $this->DiscountReason;
    }
    /**
     * Set DiscountReason value
     * @param \StructType\ParagraphType $discountReason
     * @return \StructType\DiscountType
     */
    public function setDiscountReason(\StructType\ParagraphType $discountReason = null)
    {
        $this->DiscountReason = $discountReason;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\DiscountType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\DiscountType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percent) && $percent > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percent, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percent) && $percent < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percent, true)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\DiscountType
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($discountCode) && mb_strlen($discountCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($discountCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($discountCode) && mb_strlen($discountCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get RestrictedDisplayIndicator value
     * @return bool|null
     */
    public function getRestrictedDisplayIndicator()
    {
        return $this->RestrictedDisplayIndicator;
    }
    /**
     * Set RestrictedDisplayIndicator value
     * @param bool $restrictedDisplayIndicator
     * @return \StructType\DiscountType
     */
    public function setRestrictedDisplayIndicator($restrictedDisplayIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictedDisplayIndicator) && !is_bool($restrictedDisplayIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictedDisplayIndicator, true), gettype($restrictedDisplayIndicator)), __LINE__);
        }
        $this->RestrictedDisplayIndicator = $restrictedDisplayIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
