<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationSystemCode StructType
 * Meta information extracted from the WSDL
 * - documentation: The destination system code defines a system to which information is to be provided. | Used for Character Strings, length 1 to 32.
 * - base: xs:string
 * - maxLength: 32
 * - minLength: 1
 * @subpackage Structs
 */
class DestinationSystemCode extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The ChainRateLevelCrossRef
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system code for a corresponding RateLevelCode. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ChainRateLevelCrossRef;
    /**
     * The ChainRateCodeCrossRef
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system code for a corresponding ChainRateCode. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ChainRateCodeCrossRef;
    /**
     * Constructor method for DestinationSystemCode
     * @uses DestinationSystemCode::set_()
     * @uses DestinationSystemCode::setChainRateLevelCrossRef()
     * @uses DestinationSystemCode::setChainRateCodeCrossRef()
     * @param string $_
     * @param string $chainRateLevelCrossRef
     * @param string $chainRateCodeCrossRef
     */
    public function __construct($_ = null, $chainRateLevelCrossRef = null, $chainRateCodeCrossRef = null)
    {
        $this
            ->set_($_)
            ->setChainRateLevelCrossRef($chainRateLevelCrossRef)
            ->setChainRateCodeCrossRef($chainRateCodeCrossRef);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\DestinationSystemCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($_) && mb_strlen($_) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ChainRateLevelCrossRef value
     * @return string|null
     */
    public function getChainRateLevelCrossRef()
    {
        return $this->ChainRateLevelCrossRef;
    }
    /**
     * Set ChainRateLevelCrossRef value
     * @param string $chainRateLevelCrossRef
     * @return \StructType\DestinationSystemCode
     */
    public function setChainRateLevelCrossRef($chainRateLevelCrossRef = null)
    {
        // validation for constraint: string
        if (!is_null($chainRateLevelCrossRef) && !is_string($chainRateLevelCrossRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainRateLevelCrossRef, true), gettype($chainRateLevelCrossRef)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chainRateLevelCrossRef) && mb_strlen($chainRateLevelCrossRef) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($chainRateLevelCrossRef)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainRateLevelCrossRef) && mb_strlen($chainRateLevelCrossRef) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainRateLevelCrossRef)), __LINE__);
        }
        $this->ChainRateLevelCrossRef = $chainRateLevelCrossRef;
        return $this;
    }
    /**
     * Get ChainRateCodeCrossRef value
     * @return string|null
     */
    public function getChainRateCodeCrossRef()
    {
        return $this->ChainRateCodeCrossRef;
    }
    /**
     * Set ChainRateCodeCrossRef value
     * @param string $chainRateCodeCrossRef
     * @return \StructType\DestinationSystemCode
     */
    public function setChainRateCodeCrossRef($chainRateCodeCrossRef = null)
    {
        // validation for constraint: string
        if (!is_null($chainRateCodeCrossRef) && !is_string($chainRateCodeCrossRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainRateCodeCrossRef, true), gettype($chainRateCodeCrossRef)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chainRateCodeCrossRef) && mb_strlen($chainRateCodeCrossRef) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($chainRateCodeCrossRef)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainRateCodeCrossRef) && mb_strlen($chainRateCodeCrossRef) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainRateCodeCrossRef)), __LINE__);
        }
        $this->ChainRateCodeCrossRef = $chainRateCodeCrossRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationSystemCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
