<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Description StructType
 * Meta information extracted from the WSDL
 * - documentation: The text in a specific language. | The description associated with the image in a specific language.
 * - type: xs:string
 * - use: optional
 * @subpackage Structs
 */
class Description extends FormattedTextTextType
{
    /**
     * The _
     * @var \StructType\FormattedTextTextType
     */
    public $_;
    /**
     * The Caption
     * Meta information extracted from the WSDL
     * - documentation: The caption associated to a specific image category which can be provided in different languages. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Caption;
    /**
     * The ListItem
     * Meta information extracted from the WSDL
     * - documentation: Sequence number associated with this description.
     * - use: optional
     * @var int
     */
    public $ListItem;
    /**
     * Constructor method for Description
     * @uses Description::set_()
     * @uses Description::setCaption()
     * @uses Description::setListItem()
     * @param \StructType\FormattedTextTextType $_
     * @param string $caption
     * @param int $listItem
     */
    public function __construct(\StructType\FormattedTextTextType $_ = null, $caption = null, $listItem = null)
    {
        $this
            ->set_($_)
            ->setCaption($caption)
            ->setListItem($listItem);
    }
    /**
     * Get _ value
     * @return \StructType\FormattedTextTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\FormattedTextTextType $_
     * @return \StructType\Description
     */
    public function set_(\StructType\FormattedTextTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \StructType\Description
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($caption) && mb_strlen($caption) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($caption)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($caption) && mb_strlen($caption) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ListItem value
     * @return int|null
     */
    public function getListItem()
    {
        return $this->ListItem;
    }
    /**
     * Set ListItem value
     * @param int $listItem
     * @return \StructType\Description
     */
    public function setListItem($listItem = null)
    {
        // validation for constraint: int
        if (!is_null($listItem) && !(is_int($listItem) || ctype_digit($listItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listItem, true), gettype($listItem)), __LINE__);
        }
        $this->ListItem = $listItem;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Description
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
