<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DaysOfWeeks StructType
 * Meta information extracted from the WSDL
 * - documentation: This is available so multiple rules or multiple date ranges may be applied.
 * @subpackage Structs
 */
class DaysOfWeeks extends AbstractStructBase
{
    /**
     * The DaysOfWeek
     * Meta information extracted from the WSDL
     * - documentation: Used to define room type by day of week rules for availability, required arrival, or required stay. | Used to define rate plan by day of week rules for availability, required arrival, or required stay.
     * - maxOccurs: unbounded
     * @var \StructType\DOW_RulesType[]
     */
    public $DaysOfWeek;
    /**
     * Constructor method for DaysOfWeeks
     * @uses DaysOfWeeks::setDaysOfWeek()
     * @param \StructType\DOW_RulesType[] $daysOfWeek
     */
    public function __construct(array $daysOfWeek = array())
    {
        $this
            ->setDaysOfWeek($daysOfWeek);
    }
    /**
     * Get DaysOfWeek value
     * @return \StructType\DOW_RulesType[]|null
     */
    public function getDaysOfWeek()
    {
        return $this->DaysOfWeek;
    }
    /**
     * This method is responsible for validating the values passed to the setDaysOfWeek method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDaysOfWeek method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDaysOfWeekForArrayConstraintsFromSetDaysOfWeek(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $daysOfWeeksDaysOfWeekItem) {
            // validation for constraint: itemType
            if (!$daysOfWeeksDaysOfWeekItem instanceof \StructType\DOW_RulesType) {
                $invalidValues[] = is_object($daysOfWeeksDaysOfWeekItem) ? get_class($daysOfWeeksDaysOfWeekItem) : sprintf('%s(%s)', gettype($daysOfWeeksDaysOfWeekItem), var_export($daysOfWeeksDaysOfWeekItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DaysOfWeek property can only contain items of type \StructType\DOW_RulesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DaysOfWeek value
     * @throws \InvalidArgumentException
     * @param \StructType\DOW_RulesType[] $daysOfWeek
     * @return \StructType\DaysOfWeeks
     */
    public function setDaysOfWeek(array $daysOfWeek = array())
    {
        // validation for constraint: array
        if ('' !== ($daysOfWeekArrayErrorMessage = self::validateDaysOfWeekForArrayConstraintsFromSetDaysOfWeek($daysOfWeek))) {
            throw new \InvalidArgumentException($daysOfWeekArrayErrorMessage, __LINE__);
        }
        $this->DaysOfWeek = $daysOfWeek;
        return $this;
    }
    /**
     * Add item to DaysOfWeek value
     * @throws \InvalidArgumentException
     * @param \StructType\DOW_RulesType $item
     * @return \StructType\DaysOfWeeks
     */
    public function addToDaysOfWeek(\StructType\DOW_RulesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DOW_RulesType) {
            throw new \InvalidArgumentException(sprintf('The DaysOfWeek property can only contain items of type \StructType\DOW_RulesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DaysOfWeek[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DaysOfWeeks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
