<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Date StructType
 * Meta information extracted from the WSDL
 * - documentation: Date information applicable to the fare. | Date information applicable to the fare rules.
 * - type: xs:date
 * - use: optional
 * @subpackage Structs
 */
class Date extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: The applicable date for the purpose specified in the Type attribute. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $Date;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Date
     * @uses Date::setDate()
     * @uses Date::setType()
     * @param string $date
     * @param string $type
     */
    public function __construct($date = null, $type = null)
    {
        $this
            ->setDate($date)
            ->setType($type);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the value passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForUnionConstraintsFromSetDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Date
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($dateUnionErrorMessage = self::validateDateForUnionConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateUnionErrorMessage, __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Date
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Date
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
