<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverageType StructType
 * Meta information extracted from the WSDL
 * - documentation: The CoverageType complex type describes the data that is needed to fully describe a vehicle coverage, including the core details along with optional descriptions.
 * - type: OTA_CodeType
 * - use: required
 * @subpackage Structs
 */
class CoverageType extends AbstractStructBase
{
    /**
     * The CoverageType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of coverage, for example, collision damage waiver. Refer to OpenTravel Code List Vehicle Coverage Type (VCT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: required
     * @var string
     */
    public $CoverageType;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Textual information about coverage, such as coverage limit or descriptions.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\CoverageDetailsType[]
     */
    public $Details;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Allows for an industry-specific code that describes this coverage to be specified, for example, CDW may be indicated when the coverage type is Collision Damage Waiver. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for CoverageType
     * @uses CoverageType::setCoverageType()
     * @uses CoverageType::setDetails()
     * @uses CoverageType::setCode()
     * @param string $coverageType
     * @param \StructType\CoverageDetailsType[] $details
     * @param string $code
     */
    public function __construct($coverageType = null, array $details = array(), $code = null)
    {
        $this
            ->setCoverageType($coverageType)
            ->setDetails($details)
            ->setCode($code);
    }
    /**
     * Get CoverageType value
     * @return string
     */
    public function getCoverageType()
    {
        return $this->CoverageType;
    }
    /**
     * Set CoverageType value
     * @param string $coverageType
     * @return \StructType\CoverageType
     */
    public function setCoverageType($coverageType = null)
    {
        // validation for constraint: string
        if (!is_null($coverageType) && !is_string($coverageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverageType, true), gettype($coverageType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($coverageType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $coverageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($coverageType, true)), __LINE__);
        }
        $this->CoverageType = $coverageType;
        return $this;
    }
    /**
     * Get Details value
     * @return \StructType\CoverageDetailsType[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * This method is responsible for validating the values passed to the setDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailsForArrayConstraintsFromSetDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coverageTypeDetailsItem) {
            // validation for constraint: itemType
            if (!$coverageTypeDetailsItem instanceof \StructType\CoverageDetailsType) {
                $invalidValues[] = is_object($coverageTypeDetailsItem) ? get_class($coverageTypeDetailsItem) : sprintf('%s(%s)', gettype($coverageTypeDetailsItem), var_export($coverageTypeDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Details property can only contain items of type \StructType\CoverageDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverageDetailsType[] $details
     * @return \StructType\CoverageType
     */
    public function setDetails(array $details = array())
    {
        // validation for constraint: array
        if ('' !== ($detailsArrayErrorMessage = self::validateDetailsForArrayConstraintsFromSetDetails($details))) {
            throw new \InvalidArgumentException($detailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($details) && count($details) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($details)), __LINE__);
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverageDetailsType $item
     * @return \StructType\CoverageType
     */
    public function addToDetails(\StructType\CoverageDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoverageDetailsType) {
            throw new \InvalidArgumentException(sprintf('The Details property can only contain items of type \StructType\CoverageDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Details) && count($this->Details) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Details)), __LINE__);
        }
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\CoverageType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($code) && mb_strlen($code) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoverageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
