<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverageFee StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information on one specific charge for this coverage, insurance or waiver.
 * @subpackage Structs
 */
class CoverageFee extends AbstractStructBase
{
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - documentation: Provides full information on the specific charge.
     * @var \StructType\VehicleChargeType
     */
    public $Charge;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Vehicles
     */
    public $Vehicles;
    /**
     * The Deductible
     * Meta information extracted from the WSDL
     * - documentation: The deductible/excess amount and liability amount for this coverage of a vehicle(s).
     * - minOccurs: 0
     * @var \StructType\DeductibleType
     */
    public $Deductible;
    /**
     * Constructor method for CoverageFee
     * @uses CoverageFee::setCharge()
     * @uses CoverageFee::setVehicles()
     * @uses CoverageFee::setDeductible()
     * @param \StructType\VehicleChargeType $charge
     * @param \StructType\Vehicles $vehicles
     * @param \StructType\DeductibleType $deductible
     */
    public function __construct(\StructType\VehicleChargeType $charge = null, \StructType\Vehicles $vehicles = null, \StructType\DeductibleType $deductible = null)
    {
        $this
            ->setCharge($charge)
            ->setVehicles($vehicles)
            ->setDeductible($deductible);
    }
    /**
     * Get Charge value
     * @return \StructType\VehicleChargeType|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \StructType\VehicleChargeType $charge
     * @return \StructType\CoverageFee
     */
    public function setCharge(\StructType\VehicleChargeType $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \StructType\Vehicles|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \StructType\Vehicles $vehicles
     * @return \StructType\CoverageFee
     */
    public function setVehicles(\StructType\Vehicles $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Deductible value
     * @return \StructType\DeductibleType|null
     */
    public function getDeductible()
    {
        return $this->Deductible;
    }
    /**
     * Set Deductible value
     * @param \StructType\DeductibleType $deductible
     * @return \StructType\CoverageFee
     */
    public function setDeductible(\StructType\DeductibleType $deductible = null)
    {
        $this->Deductible = $deductible;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoverageFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
