<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardIssuerName StructType
 * Meta information extracted from the WSDL
 * - documentation: Name of bank or organization issuing the card (e.g., alumni association, bank, fraternal organization). | Issuer of the card.
 * @subpackage Structs
 */
class CardIssuerName extends AbstractStructBase
{
    /**
     * The BankID
     * Meta information extracted from the WSDL
     * - documentation: Code of bank issuing the card. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * @var string
     */
    public $BankID;
    /**
     * Constructor method for CardIssuerName
     * @uses CardIssuerName::setBankID()
     * @param string $bankID
     */
    public function __construct($bankID = null)
    {
        $this
            ->setBankID($bankID);
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \StructType\CardIssuerName
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankID, true), gettype($bankID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bankID) && mb_strlen($bankID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($bankID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankID) && mb_strlen($bankID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardIssuerName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
