<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelRules StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of cancellation rules.
 * @subpackage Structs
 */
class CancelRules extends AbstractStructBase
{
    /**
     * The CancelRule
     * Meta information extracted from the WSDL
     * - documentation: Details of a cancellation rule.
     * - maxOccurs: unbounded
     * @var \StructType\CancelRuleType[]
     */
    public $CancelRule;
    /**
     * Constructor method for CancelRules
     * @uses CancelRules::setCancelRule()
     * @param \StructType\CancelRuleType[] $cancelRule
     */
    public function __construct(array $cancelRule = array())
    {
        $this
            ->setCancelRule($cancelRule);
    }
    /**
     * Get CancelRule value
     * @return \StructType\CancelRuleType[]|null
     */
    public function getCancelRule()
    {
        return $this->CancelRule;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRuleForArrayConstraintsFromSetCancelRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelRulesCancelRuleItem) {
            // validation for constraint: itemType
            if (!$cancelRulesCancelRuleItem instanceof \StructType\CancelRuleType) {
                $invalidValues[] = is_object($cancelRulesCancelRuleItem) ? get_class($cancelRulesCancelRuleItem) : sprintf('%s(%s)', gettype($cancelRulesCancelRuleItem), var_export($cancelRulesCancelRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRule property can only contain items of type \StructType\CancelRuleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRule value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRuleType[] $cancelRule
     * @return \StructType\CancelRules
     */
    public function setCancelRule(array $cancelRule = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRuleArrayErrorMessage = self::validateCancelRuleForArrayConstraintsFromSetCancelRule($cancelRule))) {
            throw new \InvalidArgumentException($cancelRuleArrayErrorMessage, __LINE__);
        }
        $this->CancelRule = $cancelRule;
        return $this;
    }
    /**
     * Add item to CancelRule value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRuleType $item
     * @return \StructType\CancelRules
     */
    public function addToCancelRule(\StructType\CancelRuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRuleType) {
            throw new \InvalidArgumentException(sprintf('The CancelRule property can only contain items of type \StructType\CancelRuleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
