<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelInfoRQType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the common, or core, information associated with the request for cancellation of a reservation or other type of record.
 * @subpackage Structs
 */
class CancelInfoRQType extends AbstractStructBase
{
    /**
     * The CancelType
     * Meta information extracted from the WSDL
     * - documentation: Used to specify if this is to initiate a cancellation or to commit the cancellation.
     * - use: required
     * @var string
     */
    public $CancelType;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: Sending own UniqueID and partner UniqueID - the receiving system needs to know which one - UniqueID acts as a reference for each system.
     * - maxOccurs: 2
     * @var \StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - documentation: The person's name in a reservation.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $PersonName;
    /**
     * Constructor method for CancelInfoRQType
     * @uses CancelInfoRQType::setCancelType()
     * @uses CancelInfoRQType::setUniqueID()
     * @uses CancelInfoRQType::setPersonName()
     * @param string $cancelType
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @param \StructType\PersonNameType $personName
     */
    public function __construct($cancelType = null, array $uniqueID = array(), \StructType\PersonNameType $personName = null)
    {
        $this
            ->setCancelType($cancelType)
            ->setUniqueID($uniqueID)
            ->setPersonName($personName);
    }
    /**
     * Get CancelType value
     * @return string
     */
    public function getCancelType()
    {
        return $this->CancelType;
    }
    /**
     * Set CancelType value
     * @uses \EnumType\TransactionActionType::valueIsValid()
     * @uses \EnumType\TransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelType
     * @return \StructType\CancelInfoRQType
     */
    public function setCancelType($cancelType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionActionType::valueIsValid($cancelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionActionType', is_array($cancelType) ? implode(', ', $cancelType) : var_export($cancelType, true), implode(', ', \EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        $this->CancelType = $cancelType;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelInfoRQTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$cancelInfoRQTypeUniqueIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($cancelInfoRQTypeUniqueIDItem) ? get_class($cancelInfoRQTypeUniqueIDItem) : sprintf('%s(%s)', gettype($cancelInfoRQTypeUniqueIDItem), var_export($cancelInfoRQTypeUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @return \StructType\CancelInfoRQType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($uniqueID) && count($uniqueID) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\CancelInfoRQType
     */
    public function addToUniqueID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->UniqueID) && count($this->UniqueID) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->UniqueID)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonNameType $personName
     * @return \StructType\CancelInfoRQType
     */
    public function setPersonName(\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelInfoRQType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
