<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClassType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the Cabin details in a seat map
 * @subpackage Structs
 */
class CabinClassType extends AbstractStructBase
{
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Cabin class for which the seat map details is being given. Could be first, business or economy.
     * - use: required
     * @var string
     */
    public $CabinType;
    /**
     * The AirRows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirRows
     */
    public $AirRows;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name that a particular airline/ CRS may give to the cabin class | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CabinClassType
     * @uses CabinClassType::setCabinType()
     * @uses CabinClassType::setAirRows()
     * @uses CabinClassType::setName()
     * @param string $cabinType
     * @param \StructType\AirRows $airRows
     * @param string $name
     */
    public function __construct($cabinType = null, \StructType\AirRows $airRows = null, $name = null)
    {
        $this
            ->setCabinType($cabinType)
            ->setAirRows($airRows)
            ->setName($name);
    }
    /**
     * Get CabinType value
     * @return string
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \StructType\CabinClassType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabinType) ? implode(', ', $cabinType) : var_export($cabinType, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get AirRows value
     * @return \StructType\AirRows|null
     */
    public function getAirRows()
    {
        return $this->AirRows;
    }
    /**
     * Set AirRows value
     * @param \StructType\AirRows $airRows
     * @return \StructType\CabinClassType
     */
    public function setAirRows(\StructType\AirRows $airRows = null)
    {
        $this->AirRows = $airRows;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CabinClassType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($name) && mb_strlen($name) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinClassType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
