<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClass StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the Cabin details in a seat map.
 * @subpackage Structs
 */
class CabinClass extends CabinClassType
{
    /**
     * The StartingRow
     * Meta information extracted from the WSDL
     * - documentation: Specify the starting row number for this cabin class. | Used for Numeric values, from 1 to 3 inclusive.
     * - base: xs:integer
     * - maxInclusive: 3
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $StartingRow;
    /**
     * The EndingRow
     * Meta information extracted from the WSDL
     * - documentation: Specify the ending row number for this cabin class. | Used for Numeric values, from 1 to 3 inclusive.
     * - base: xs:integer
     * - maxInclusive: 3
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $EndingRow;
    /**
     * Constructor method for CabinClass
     * @uses CabinClass::setStartingRow()
     * @uses CabinClass::setEndingRow()
     * @param int $startingRow
     * @param int $endingRow
     */
    public function __construct($startingRow = null, $endingRow = null)
    {
        $this
            ->setStartingRow($startingRow)
            ->setEndingRow($endingRow);
    }
    /**
     * Get StartingRow value
     * @return int|null
     */
    public function getStartingRow()
    {
        return $this->StartingRow;
    }
    /**
     * Set StartingRow value
     * @param int $startingRow
     * @return \StructType\CabinClass
     */
    public function setStartingRow($startingRow = null)
    {
        // validation for constraint: int
        if (!is_null($startingRow) && !(is_int($startingRow) || ctype_digit($startingRow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startingRow, true), gettype($startingRow)), __LINE__);
        }
        // validation for constraint: maxInclusive(3)
        if (!is_null($startingRow) && $startingRow > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 3', var_export($startingRow, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($startingRow) && $startingRow < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($startingRow, true)), __LINE__);
        }
        $this->StartingRow = $startingRow;
        return $this;
    }
    /**
     * Get EndingRow value
     * @return int|null
     */
    public function getEndingRow()
    {
        return $this->EndingRow;
    }
    /**
     * Set EndingRow value
     * @param int $endingRow
     * @return \StructType\CabinClass
     */
    public function setEndingRow($endingRow = null)
    {
        // validation for constraint: int
        if (!is_null($endingRow) && !(is_int($endingRow) || ctype_digit($endingRow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endingRow, true), gettype($endingRow)), __LINE__);
        }
        // validation for constraint: maxInclusive(3)
        if (!is_null($endingRow) && $endingRow > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 3', var_export($endingRow, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($endingRow) && $endingRow < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($endingRow, true)), __LINE__);
        }
        $this->EndingRow = $endingRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinClass
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
