<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingRule StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines when block inventory is released back to general inventory. | Used to specify a rate plan code, room type code or rate plan/room type combination code and its associated attributes. | The BookingRule element defines
 * restrictions to rates and stays at the hotel for a given rate plan, room type or rate plan/room type combination.
 * @subpackage Structs
 */
class BookingRule extends AbstractStructBase
{
    /**
     * The AcceptableGuarantees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AcceptableGuarantees
     */
    public $AcceptableGuarantees;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - documentation: A collection of required payments that are part of the booking restriction.
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The RequiredPaymts
     * Meta information extracted from the WSDL
     * - documentation: A collection of required payments that are part of the booking restriction.
     * - minOccurs: 0
     * @var \StructType\RequiredPaymentsType
     */
    public $RequiredPaymts;
    /**
     * The LengthsOfStay
     * Meta information extracted from the WSDL
     * - documentation: A collection of lengths of stay.
     * - minOccurs: 0
     * @var \StructType\LengthsOfStayType
     */
    public $LengthsOfStay;
    /**
     * The DOW_Restrictions
     * Meta information extracted from the WSDL
     * - documentation: A collection of Day Of Week restrictions.
     * - minOccurs: 0
     * @var \StructType\DOW_RestrictionsType
     */
    public $DOW_Restrictions;
    /**
     * The RestrictionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RestrictionStatus
     */
    public $RestrictionStatus;
    /**
     * The Viewerships
     * Meta information extracted from the WSDL
     * - documentation: A collection of Viewships.
     * - minOccurs: 0
     * @var \StructType\ViewershipsType
     */
    public $Viewerships;
    /**
     * The AddtionalRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddtionalRules
     */
    public $AddtionalRules;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: General description of booking rule.
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier element allows the trading partners to uniquely identify each Booking Rule, for transaction tracability.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The CheckoutCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\CheckoutCharge[]
     */
    public $CheckoutCharge;
    /**
     * The MaxAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Maximum days before the arrival date for which this rate plan may be booked.
     * - use: optional
     * @var string
     */
    public $MaxAdvancedBookingOffset;
    /**
     * The MinAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Minimum days before the arrival date for which this rate plan may be booked.
     * - use: optional
     * @var string
     */
    public $MinAdvancedBookingOffset;
    /**
     * The ForceGuaranteeOffset
     * Meta information extracted from the WSDL
     * - documentation: Number of days prior to arrival date at which a guarantee is required.
     * - use: optional
     * @var string
     */
    public $ForceGuaranteeOffset;
    /**
     * The DepositWaiverOffset
     * Meta information extracted from the WSDL
     * - documentation: Number of days prior to arrival date for which a deposit is no longer accepted (because of a too short time delay between reservation and guest arrival).
     * - use: optional
     * @var string
     */
    public $DepositWaiverOffset;
    /**
     * The MinTotalOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Defines the minimum number of total occupants required for a rate plan.
     * - use: optional
     * @var int
     */
    public $MinTotalOccupancy;
    /**
     * The MaxTotalOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Defines the maximum number of total occupants allowed for a rate plan.
     * - use: optional
     * @var int
     */
    public $MaxTotalOccupancy;
    /**
     * The AbsoluteDropTime
     * Meta information extracted from the WSDL
     * - documentation: The fixed time that the booking restriction goes into effect to cancel the non-guaranteed reservation. Either this attribute or the DropTimeOffset element may be used. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $AbsoluteDropTime;
    /**
     * The GenerallyBookable
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this rate plan can be booked by those not in the viewership collection. If this attribute is False (0), then the viewerships collection lists those who have view-only or bookable status for this rate plan. If this
     * attribute is True (1), then the viewerships collection lists those who have view-only or not-viewable status for this rate plan.
     * - use: optional
     * @var bool
     */
    public $GenerallyBookable;
    /**
     * The PriceViewable
     * Meta information extracted from the WSDL
     * - documentation: Valid values: 0 = (No) Price Not Viewable, 1 = (Yes) Price Viewable. | Indicates whether the price for this rate plan can be viewed, or whether the guest must contact another entity to obtain price information.
     * - use: optional
     * @var bool
     */
    public $PriceViewable;
    /**
     * The QualifiedRateYN
     * Meta information extracted from the WSDL
     * - documentation: Boolean value indicating whether a specific rate plan must be qualified prior to inclusion in availability response messages.
     * - use: optional
     * @var bool
     */
    public $QualifiedRateYN;
    /**
     * The AddressRequired
     * Meta information extracted from the WSDL
     * - documentation: An address is required to complete the booking.
     * - use: optional
     * @var bool
     */
    public $AddressRequired;
    /**
     * The MaxContiguousBookings
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of times a rate may be booked contiguously within a reservation (often used with packages).
     * - use: optional
     * @var int
     */
    public $MaxContiguousBookings;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * The AbsoluteCutoff
     * Meta information extracted from the WSDL
     * - documentation: Defines the absolute deadline. Either this or the offset attributes may be used. | A construct to validate either a date or a time or a dateTime value.
     * - type: DateOrTimeOrDateTimeType
     * - union: date | dateTime | time
     * - use: optional
     * @var string
     */
    public $AbsoluteCutoff;
    /**
     * The OffsetDuration
     * Meta information extracted from the WSDL
     * - documentation: The units of time, e.g.: days, hours, etc., that apply to the deadline.
     * - type: xs:duration
     * - use: optional
     * @var string
     */
    public $OffsetDuration;
    /**
     * The OffsetCalculationMode
     * @var string
     */
    public $OffsetCalculationMode;
    /**
     * Constructor method for BookingRule
     * @uses BookingRule::setAcceptableGuarantees()
     * @uses BookingRule::setCancelPenalties()
     * @uses BookingRule::setRequiredPaymts()
     * @uses BookingRule::setLengthsOfStay()
     * @uses BookingRule::setDOW_Restrictions()
     * @uses BookingRule::setRestrictionStatus()
     * @uses BookingRule::setViewerships()
     * @uses BookingRule::setAddtionalRules()
     * @uses BookingRule::setDescription()
     * @uses BookingRule::setUniqueID()
     * @uses BookingRule::setCheckoutCharge()
     * @uses BookingRule::setMaxAdvancedBookingOffset()
     * @uses BookingRule::setMinAdvancedBookingOffset()
     * @uses BookingRule::setForceGuaranteeOffset()
     * @uses BookingRule::setDepositWaiverOffset()
     * @uses BookingRule::setMinTotalOccupancy()
     * @uses BookingRule::setMaxTotalOccupancy()
     * @uses BookingRule::setAbsoluteDropTime()
     * @uses BookingRule::setGenerallyBookable()
     * @uses BookingRule::setPriceViewable()
     * @uses BookingRule::setQualifiedRateYN()
     * @uses BookingRule::setAddressRequired()
     * @uses BookingRule::setMaxContiguousBookings()
     * @uses BookingRule::setURI()
     * @uses BookingRule::setCode()
     * @uses BookingRule::setCodeContext()
     * @uses BookingRule::setQuantity()
     * @uses BookingRule::setStart()
     * @uses BookingRule::setDuration()
     * @uses BookingRule::setEnd()
     * @uses BookingRule::setAbsoluteCutoff()
     * @uses BookingRule::setOffsetDuration()
     * @uses BookingRule::setOffsetCalculationMode()
     * @param \StructType\AcceptableGuarantees $acceptableGuarantees
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \StructType\RequiredPaymentsType $requiredPaymts
     * @param \StructType\LengthsOfStayType $lengthsOfStay
     * @param \StructType\DOW_RestrictionsType $dOW_Restrictions
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @param \StructType\ViewershipsType $viewerships
     * @param \StructType\AddtionalRules $addtionalRules
     * @param \StructType\ParagraphType[] $description
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\CheckoutCharge[] $checkoutCharge
     * @param string $maxAdvancedBookingOffset
     * @param string $minAdvancedBookingOffset
     * @param string $forceGuaranteeOffset
     * @param string $depositWaiverOffset
     * @param int $minTotalOccupancy
     * @param int $maxTotalOccupancy
     * @param string $absoluteDropTime
     * @param bool $generallyBookable
     * @param bool $priceViewable
     * @param bool $qualifiedRateYN
     * @param bool $addressRequired
     * @param int $maxContiguousBookings
     * @param string $uRI
     * @param string $code
     * @param string $codeContext
     * @param int $quantity
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $absoluteCutoff
     * @param string $offsetDuration
     * @param string $offsetCalculationMode
     */
    public function __construct(\StructType\AcceptableGuarantees $acceptableGuarantees = null, \StructType\CancelPenaltiesType $cancelPenalties = null, \StructType\RequiredPaymentsType $requiredPaymts = null, \StructType\LengthsOfStayType $lengthsOfStay = null, \StructType\DOW_RestrictionsType $dOW_Restrictions = null, \StructType\RestrictionStatus $restrictionStatus = null, \StructType\ViewershipsType $viewerships = null, \StructType\AddtionalRules $addtionalRules = null, array $description = array(), \StructType\UniqueID_Type $uniqueID = null, array $checkoutCharge = array(), $maxAdvancedBookingOffset = null, $minAdvancedBookingOffset = null, $forceGuaranteeOffset = null, $depositWaiverOffset = null, $minTotalOccupancy = null, $maxTotalOccupancy = null, $absoluteDropTime = null, $generallyBookable = null, $priceViewable = null, $qualifiedRateYN = null, $addressRequired = null, $maxContiguousBookings = null, $uRI = null, $code = null, $codeContext = null, $quantity = null, $start = null, $duration = null, $end = null, $absoluteCutoff = null, $offsetDuration = null, $offsetCalculationMode = null)
    {
        $this
            ->setAcceptableGuarantees($acceptableGuarantees)
            ->setCancelPenalties($cancelPenalties)
            ->setRequiredPaymts($requiredPaymts)
            ->setLengthsOfStay($lengthsOfStay)
            ->setDOW_Restrictions($dOW_Restrictions)
            ->setRestrictionStatus($restrictionStatus)
            ->setViewerships($viewerships)
            ->setAddtionalRules($addtionalRules)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setCheckoutCharge($checkoutCharge)
            ->setMaxAdvancedBookingOffset($maxAdvancedBookingOffset)
            ->setMinAdvancedBookingOffset($minAdvancedBookingOffset)
            ->setForceGuaranteeOffset($forceGuaranteeOffset)
            ->setDepositWaiverOffset($depositWaiverOffset)
            ->setMinTotalOccupancy($minTotalOccupancy)
            ->setMaxTotalOccupancy($maxTotalOccupancy)
            ->setAbsoluteDropTime($absoluteDropTime)
            ->setGenerallyBookable($generallyBookable)
            ->setPriceViewable($priceViewable)
            ->setQualifiedRateYN($qualifiedRateYN)
            ->setAddressRequired($addressRequired)
            ->setMaxContiguousBookings($maxContiguousBookings)
            ->setURI($uRI)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setQuantity($quantity)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setAbsoluteCutoff($absoluteCutoff)
            ->setOffsetDuration($offsetDuration)
            ->setOffsetCalculationMode($offsetCalculationMode);
    }
    /**
     * Get AcceptableGuarantees value
     * @return \StructType\AcceptableGuarantees|null
     */
    public function getAcceptableGuarantees()
    {
        return $this->AcceptableGuarantees;
    }
    /**
     * Set AcceptableGuarantees value
     * @param \StructType\AcceptableGuarantees $acceptableGuarantees
     * @return \StructType\BookingRule
     */
    public function setAcceptableGuarantees(\StructType\AcceptableGuarantees $acceptableGuarantees = null)
    {
        $this->AcceptableGuarantees = $acceptableGuarantees;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\BookingRule
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get RequiredPaymts value
     * @return \StructType\RequiredPaymentsType|null
     */
    public function getRequiredPaymts()
    {
        return $this->RequiredPaymts;
    }
    /**
     * Set RequiredPaymts value
     * @param \StructType\RequiredPaymentsType $requiredPaymts
     * @return \StructType\BookingRule
     */
    public function setRequiredPaymts(\StructType\RequiredPaymentsType $requiredPaymts = null)
    {
        $this->RequiredPaymts = $requiredPaymts;
        return $this;
    }
    /**
     * Get LengthsOfStay value
     * @return \StructType\LengthsOfStayType|null
     */
    public function getLengthsOfStay()
    {
        return $this->LengthsOfStay;
    }
    /**
     * Set LengthsOfStay value
     * @param \StructType\LengthsOfStayType $lengthsOfStay
     * @return \StructType\BookingRule
     */
    public function setLengthsOfStay(\StructType\LengthsOfStayType $lengthsOfStay = null)
    {
        $this->LengthsOfStay = $lengthsOfStay;
        return $this;
    }
    /**
     * Get DOW_Restrictions value
     * @return \StructType\DOW_RestrictionsType|null
     */
    public function getDOW_Restrictions()
    {
        return $this->DOW_Restrictions;
    }
    /**
     * Set DOW_Restrictions value
     * @param \StructType\DOW_RestrictionsType $dOW_Restrictions
     * @return \StructType\BookingRule
     */
    public function setDOW_Restrictions(\StructType\DOW_RestrictionsType $dOW_Restrictions = null)
    {
        $this->DOW_Restrictions = $dOW_Restrictions;
        return $this;
    }
    /**
     * Get RestrictionStatus value
     * @return \StructType\RestrictionStatus|null
     */
    public function getRestrictionStatus()
    {
        return $this->RestrictionStatus;
    }
    /**
     * Set RestrictionStatus value
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @return \StructType\BookingRule
     */
    public function setRestrictionStatus(\StructType\RestrictionStatus $restrictionStatus = null)
    {
        $this->RestrictionStatus = $restrictionStatus;
        return $this;
    }
    /**
     * Get Viewerships value
     * @return \StructType\ViewershipsType|null
     */
    public function getViewerships()
    {
        return $this->Viewerships;
    }
    /**
     * Set Viewerships value
     * @param \StructType\ViewershipsType $viewerships
     * @return \StructType\BookingRule
     */
    public function setViewerships(\StructType\ViewershipsType $viewerships = null)
    {
        $this->Viewerships = $viewerships;
        return $this;
    }
    /**
     * Get AddtionalRules value
     * @return \StructType\AddtionalRules|null
     */
    public function getAddtionalRules()
    {
        return $this->AddtionalRules;
    }
    /**
     * Set AddtionalRules value
     * @param \StructType\AddtionalRules $addtionalRules
     * @return \StructType\BookingRule
     */
    public function setAddtionalRules(\StructType\AddtionalRules $addtionalRules = null)
    {
        $this->AddtionalRules = $addtionalRules;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingRuleDescriptionItem) {
            // validation for constraint: itemType
            if (!$bookingRuleDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($bookingRuleDescriptionItem) ? get_class($bookingRuleDescriptionItem) : sprintf('%s(%s)', gettype($bookingRuleDescriptionItem), var_export($bookingRuleDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $description
     * @return \StructType\BookingRule
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($description) && count($description) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\BookingRule
     */
    public function addToDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->Description) && count($this->Description) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\BookingRule
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CheckoutCharge value
     * @return \StructType\CheckoutCharge[]|null
     */
    public function getCheckoutCharge()
    {
        return $this->CheckoutCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckoutCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckoutCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckoutChargeForArrayConstraintsFromSetCheckoutCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingRuleCheckoutChargeItem) {
            // validation for constraint: itemType
            if (!$bookingRuleCheckoutChargeItem instanceof \StructType\CheckoutCharge) {
                $invalidValues[] = is_object($bookingRuleCheckoutChargeItem) ? get_class($bookingRuleCheckoutChargeItem) : sprintf('%s(%s)', gettype($bookingRuleCheckoutChargeItem), var_export($bookingRuleCheckoutChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CheckoutCharge property can only contain items of type \StructType\CheckoutCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckoutCharge[] $checkoutCharge
     * @return \StructType\BookingRule
     */
    public function setCheckoutCharge(array $checkoutCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($checkoutChargeArrayErrorMessage = self::validateCheckoutChargeForArrayConstraintsFromSetCheckoutCharge($checkoutCharge))) {
            throw new \InvalidArgumentException($checkoutChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($checkoutCharge) && count($checkoutCharge) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($checkoutCharge)), __LINE__);
        }
        $this->CheckoutCharge = $checkoutCharge;
        return $this;
    }
    /**
     * Add item to CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckoutCharge $item
     * @return \StructType\BookingRule
     */
    public function addToCheckoutCharge(\StructType\CheckoutCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CheckoutCharge) {
            throw new \InvalidArgumentException(sprintf('The CheckoutCharge property can only contain items of type \StructType\CheckoutCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->CheckoutCharge) && count($this->CheckoutCharge) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->CheckoutCharge)), __LINE__);
        }
        $this->CheckoutCharge[] = $item;
        return $this;
    }
    /**
     * Get MaxAdvancedBookingOffset value
     * @return string|null
     */
    public function getMaxAdvancedBookingOffset()
    {
        return $this->MaxAdvancedBookingOffset;
    }
    /**
     * Set MaxAdvancedBookingOffset value
     * @param string $maxAdvancedBookingOffset
     * @return \StructType\BookingRule
     */
    public function setMaxAdvancedBookingOffset($maxAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdvancedBookingOffset) && !is_string($maxAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxAdvancedBookingOffset, true), gettype($maxAdvancedBookingOffset)), __LINE__);
        }
        $this->MaxAdvancedBookingOffset = $maxAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get MinAdvancedBookingOffset value
     * @return string|null
     */
    public function getMinAdvancedBookingOffset()
    {
        return $this->MinAdvancedBookingOffset;
    }
    /**
     * Set MinAdvancedBookingOffset value
     * @param string $minAdvancedBookingOffset
     * @return \StructType\BookingRule
     */
    public function setMinAdvancedBookingOffset($minAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($minAdvancedBookingOffset) && !is_string($minAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minAdvancedBookingOffset, true), gettype($minAdvancedBookingOffset)), __LINE__);
        }
        $this->MinAdvancedBookingOffset = $minAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get ForceGuaranteeOffset value
     * @return string|null
     */
    public function getForceGuaranteeOffset()
    {
        return $this->ForceGuaranteeOffset;
    }
    /**
     * Set ForceGuaranteeOffset value
     * @param string $forceGuaranteeOffset
     * @return \StructType\BookingRule
     */
    public function setForceGuaranteeOffset($forceGuaranteeOffset = null)
    {
        // validation for constraint: string
        if (!is_null($forceGuaranteeOffset) && !is_string($forceGuaranteeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceGuaranteeOffset, true), gettype($forceGuaranteeOffset)), __LINE__);
        }
        $this->ForceGuaranteeOffset = $forceGuaranteeOffset;
        return $this;
    }
    /**
     * Get DepositWaiverOffset value
     * @return string|null
     */
    public function getDepositWaiverOffset()
    {
        return $this->DepositWaiverOffset;
    }
    /**
     * Set DepositWaiverOffset value
     * @param string $depositWaiverOffset
     * @return \StructType\BookingRule
     */
    public function setDepositWaiverOffset($depositWaiverOffset = null)
    {
        // validation for constraint: string
        if (!is_null($depositWaiverOffset) && !is_string($depositWaiverOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositWaiverOffset, true), gettype($depositWaiverOffset)), __LINE__);
        }
        $this->DepositWaiverOffset = $depositWaiverOffset;
        return $this;
    }
    /**
     * Get MinTotalOccupancy value
     * @return int|null
     */
    public function getMinTotalOccupancy()
    {
        return $this->MinTotalOccupancy;
    }
    /**
     * Set MinTotalOccupancy value
     * @param int $minTotalOccupancy
     * @return \StructType\BookingRule
     */
    public function setMinTotalOccupancy($minTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minTotalOccupancy) && !(is_int($minTotalOccupancy) || ctype_digit($minTotalOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTotalOccupancy, true), gettype($minTotalOccupancy)), __LINE__);
        }
        $this->MinTotalOccupancy = $minTotalOccupancy;
        return $this;
    }
    /**
     * Get MaxTotalOccupancy value
     * @return int|null
     */
    public function getMaxTotalOccupancy()
    {
        return $this->MaxTotalOccupancy;
    }
    /**
     * Set MaxTotalOccupancy value
     * @param int $maxTotalOccupancy
     * @return \StructType\BookingRule
     */
    public function setMaxTotalOccupancy($maxTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxTotalOccupancy) && !(is_int($maxTotalOccupancy) || ctype_digit($maxTotalOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTotalOccupancy, true), gettype($maxTotalOccupancy)), __LINE__);
        }
        $this->MaxTotalOccupancy = $maxTotalOccupancy;
        return $this;
    }
    /**
     * Get AbsoluteDropTime value
     * @return string|null
     */
    public function getAbsoluteDropTime()
    {
        return $this->AbsoluteDropTime;
    }
    /**
     * This method is responsible for validating the value passed to the setAbsoluteDropTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbsoluteDropTime method
     * This is a set of validation rules based on the union types associated to the property being set by the setAbsoluteDropTime method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbsoluteDropTimeForUnionConstraintsFromSetAbsoluteDropTime($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set AbsoluteDropTime value
     * @param string $absoluteDropTime
     * @return \StructType\BookingRule
     */
    public function setAbsoluteDropTime($absoluteDropTime = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDropTime) && !is_string($absoluteDropTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteDropTime, true), gettype($absoluteDropTime)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($absoluteDropTimeUnionErrorMessage = self::validateAbsoluteDropTimeForUnionConstraintsFromSetAbsoluteDropTime($absoluteDropTime))) {
            throw new \InvalidArgumentException($absoluteDropTimeUnionErrorMessage, __LINE__);
        }
        $this->AbsoluteDropTime = $absoluteDropTime;
        return $this;
    }
    /**
     * Get GenerallyBookable value
     * @return bool|null
     */
    public function getGenerallyBookable()
    {
        return $this->GenerallyBookable;
    }
    /**
     * Set GenerallyBookable value
     * @param bool $generallyBookable
     * @return \StructType\BookingRule
     */
    public function setGenerallyBookable($generallyBookable = null)
    {
        // validation for constraint: boolean
        if (!is_null($generallyBookable) && !is_bool($generallyBookable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generallyBookable, true), gettype($generallyBookable)), __LINE__);
        }
        $this->GenerallyBookable = $generallyBookable;
        return $this;
    }
    /**
     * Get PriceViewable value
     * @return bool|null
     */
    public function getPriceViewable()
    {
        return $this->PriceViewable;
    }
    /**
     * Set PriceViewable value
     * @param bool $priceViewable
     * @return \StructType\BookingRule
     */
    public function setPriceViewable($priceViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceViewable) && !is_bool($priceViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceViewable, true), gettype($priceViewable)), __LINE__);
        }
        $this->PriceViewable = $priceViewable;
        return $this;
    }
    /**
     * Get QualifiedRateYN value
     * @return bool|null
     */
    public function getQualifiedRateYN()
    {
        return $this->QualifiedRateYN;
    }
    /**
     * Set QualifiedRateYN value
     * @param bool $qualifiedRateYN
     * @return \StructType\BookingRule
     */
    public function setQualifiedRateYN($qualifiedRateYN = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifiedRateYN) && !is_bool($qualifiedRateYN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($qualifiedRateYN, true), gettype($qualifiedRateYN)), __LINE__);
        }
        $this->QualifiedRateYN = $qualifiedRateYN;
        return $this;
    }
    /**
     * Get AddressRequired value
     * @return bool|null
     */
    public function getAddressRequired()
    {
        return $this->AddressRequired;
    }
    /**
     * Set AddressRequired value
     * @param bool $addressRequired
     * @return \StructType\BookingRule
     */
    public function setAddressRequired($addressRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressRequired) && !is_bool($addressRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressRequired, true), gettype($addressRequired)), __LINE__);
        }
        $this->AddressRequired = $addressRequired;
        return $this;
    }
    /**
     * Get MaxContiguousBookings value
     * @return int|null
     */
    public function getMaxContiguousBookings()
    {
        return $this->MaxContiguousBookings;
    }
    /**
     * Set MaxContiguousBookings value
     * @param int $maxContiguousBookings
     * @return \StructType\BookingRule
     */
    public function setMaxContiguousBookings($maxContiguousBookings = null)
    {
        // validation for constraint: int
        if (!is_null($maxContiguousBookings) && !(is_int($maxContiguousBookings) || ctype_digit($maxContiguousBookings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxContiguousBookings, true), gettype($maxContiguousBookings)), __LINE__);
        }
        $this->MaxContiguousBookings = $maxContiguousBookings;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\BookingRule
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\BookingRule
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($code) && mb_strlen($code) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\BookingRule
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\BookingRule
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\BookingRule
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\BookingRule
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\BookingRule
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get AbsoluteCutoff value
     * @return string|null
     */
    public function getAbsoluteCutoff()
    {
        return $this->AbsoluteCutoff;
    }
    /**
     * This method is responsible for validating the value passed to the setAbsoluteCutoff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbsoluteCutoff method
     * This is a set of validation rules based on the union types associated to the property being set by the setAbsoluteCutoff method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbsoluteCutoffForUnionConstraintsFromSetAbsoluteCutoff($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set AbsoluteCutoff value
     * @param string $absoluteCutoff
     * @return \StructType\BookingRule
     */
    public function setAbsoluteCutoff($absoluteCutoff = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteCutoff) && !is_string($absoluteCutoff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteCutoff, true), gettype($absoluteCutoff)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($absoluteCutoffUnionErrorMessage = self::validateAbsoluteCutoffForUnionConstraintsFromSetAbsoluteCutoff($absoluteCutoff))) {
            throw new \InvalidArgumentException($absoluteCutoffUnionErrorMessage, __LINE__);
        }
        $this->AbsoluteCutoff = $absoluteCutoff;
        return $this;
    }
    /**
     * Get OffsetDuration value
     * @return string|null
     */
    public function getOffsetDuration()
    {
        return $this->OffsetDuration;
    }
    /**
     * Set OffsetDuration value
     * @param string $offsetDuration
     * @return \StructType\BookingRule
     */
    public function setOffsetDuration($offsetDuration = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDuration) && !is_string($offsetDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetDuration, true), gettype($offsetDuration)), __LINE__);
        }
        $this->OffsetDuration = $offsetDuration;
        return $this;
    }
    /**
     * Get OffsetCalculationMode value
     * @return string|null
     */
    public function getOffsetCalculationMode()
    {
        return $this->OffsetCalculationMode;
    }
    /**
     * Set OffsetCalculationMode value
     * @param string $offsetCalculationMode
     * @return \StructType\BookingRule
     */
    public function setOffsetCalculationMode($offsetCalculationMode = null)
    {
        // validation for constraint: string
        if (!is_null($offsetCalculationMode) && !is_string($offsetCalculationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetCalculationMode, true), gettype($offsetCalculationMode)), __LINE__);
        }
        $this->OffsetCalculationMode = $offsetCalculationMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
