<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies a booking class to be included or excluded in the response. | Specifies specific booking classes to include and/or exclude in the response.
 * @subpackage Structs
 */
class BookingClassPref extends AbstractStructBase
{
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Booking class code | Used for an Alpha String, length 1 to 2 (for letter codes).
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - type: UpperCaseAlphaLength1to2
     * - use: required
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ResBookDesigCodeType
     * @var string
     */
    public $ResBookDesigCodeType;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for BookingClassPref
     * @uses BookingClassPref::setResBookDesigCode()
     * @uses BookingClassPref::setResBookDesigCodeType()
     * @uses BookingClassPref::setPreferLevel()
     * @param string $resBookDesigCode
     * @param string $resBookDesigCodeType
     * @param string $preferLevel
     */
    public function __construct($resBookDesigCode = null, $resBookDesigCodeType = null, $preferLevel = null)
    {
        $this
            ->setResBookDesigCode($resBookDesigCode)
            ->setResBookDesigCodeType($resBookDesigCodeType)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get ResBookDesigCode value
     * @return string
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\BookingClassPref
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($resBookDesigCode) && !preg_match('/[A-Z]{1,2}/', $resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($resBookDesigCode, true)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ResBookDesigCodeType value
     * @return string|null
     */
    public function getResBookDesigCodeType()
    {
        return $this->ResBookDesigCodeType;
    }
    /**
     * Set ResBookDesigCodeType value
     * @param string $resBookDesigCodeType
     * @return \StructType\BookingClassPref
     */
    public function setResBookDesigCodeType($resBookDesigCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCodeType) && !is_string($resBookDesigCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCodeType, true), gettype($resBookDesigCodeType)), __LINE__);
        }
        $this->ResBookDesigCodeType = $resBookDesigCodeType;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\BookingClassPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingClassPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
