<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassAvails StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of availability counts per booking class.
 * @subpackage Structs
 */
class BookingClassAvails extends AbstractStructBase
{
    /**
     * The BookingClassAvail
     * Meta information extracted from the WSDL
     * - maxOccurs: 26
     * @var \StructType\BookingClassAvail[]
     */
    public $BookingClassAvail;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Marketing name as defined by an airline for the first, business or economy cabin.
     * - use: optional
     * @var string
     */
    public $CabinType;
    /**
     * Constructor method for BookingClassAvails
     * @uses BookingClassAvails::setBookingClassAvail()
     * @uses BookingClassAvails::setCabinType()
     * @param \StructType\BookingClassAvail[] $bookingClassAvail
     * @param string $cabinType
     */
    public function __construct(array $bookingClassAvail = array(), $cabinType = null)
    {
        $this
            ->setBookingClassAvail($bookingClassAvail)
            ->setCabinType($cabinType);
    }
    /**
     * Get BookingClassAvail value
     * @return \StructType\BookingClassAvail[]|null
     */
    public function getBookingClassAvail()
    {
        return $this->BookingClassAvail;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingClassAvail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingClassAvail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingClassAvailForArrayConstraintsFromSetBookingClassAvail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingClassAvailsBookingClassAvailItem) {
            // validation for constraint: itemType
            if (!$bookingClassAvailsBookingClassAvailItem instanceof \StructType\BookingClassAvail) {
                $invalidValues[] = is_object($bookingClassAvailsBookingClassAvailItem) ? get_class($bookingClassAvailsBookingClassAvailItem) : sprintf('%s(%s)', gettype($bookingClassAvailsBookingClassAvailItem), var_export($bookingClassAvailsBookingClassAvailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingClassAvail property can only contain items of type \StructType\BookingClassAvail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvail[] $bookingClassAvail
     * @return \StructType\BookingClassAvails
     */
    public function setBookingClassAvail(array $bookingClassAvail = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingClassAvailArrayErrorMessage = self::validateBookingClassAvailForArrayConstraintsFromSetBookingClassAvail($bookingClassAvail))) {
            throw new \InvalidArgumentException($bookingClassAvailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(26)
        if (is_array($bookingClassAvail) && count($bookingClassAvail) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 26', count($bookingClassAvail)), __LINE__);
        }
        $this->BookingClassAvail = $bookingClassAvail;
        return $this;
    }
    /**
     * Add item to BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvail $item
     * @return \StructType\BookingClassAvails
     */
    public function addToBookingClassAvail(\StructType\BookingClassAvail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingClassAvail) {
            throw new \InvalidArgumentException(sprintf('The BookingClassAvail property can only contain items of type \StructType\BookingClassAvail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(26)
        if (is_array($this->BookingClassAvail) && count($this->BookingClassAvail) >= 26) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 26', count($this->BookingClassAvail)), __LINE__);
        }
        $this->BookingClassAvail[] = $item;
        return $this;
    }
    /**
     * Get CabinType value
     * @return string|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \StructType\BookingClassAvails
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabinType) ? implode(', ', $cabinType) : var_export($cabinType, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingClassAvails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
