<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingChannelCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: A collections of strings that identify booking channels, such as GDSs or Internet sites, etc., associated with this viewership record.
 * @subpackage Structs
 */
class BookingChannelCodes extends AbstractStructBase
{
    /**
     * The BookingChannelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\BookingChannelCode[]
     */
    public $BookingChannelCode;
    /**
     * The ChannelCodesInclusive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the collection of Channel Codes for booking channels is inclusive or exclusive. Values: false=Exclusive, true=Inclusive.
     * - use: optional
     * @var bool
     */
    public $ChannelCodesInclusive;
    /**
     * Constructor method for BookingChannelCodes
     * @uses BookingChannelCodes::setBookingChannelCode()
     * @uses BookingChannelCodes::setChannelCodesInclusive()
     * @param \StructType\BookingChannelCode[] $bookingChannelCode
     * @param bool $channelCodesInclusive
     */
    public function __construct(array $bookingChannelCode = array(), $channelCodesInclusive = null)
    {
        $this
            ->setBookingChannelCode($bookingChannelCode)
            ->setChannelCodesInclusive($channelCodesInclusive);
    }
    /**
     * Get BookingChannelCode value
     * @return \StructType\BookingChannelCode[]|null
     */
    public function getBookingChannelCode()
    {
        return $this->BookingChannelCode;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingChannelCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingChannelCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingChannelCodeForArrayConstraintsFromSetBookingChannelCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingChannelCodesBookingChannelCodeItem) {
            // validation for constraint: itemType
            if (!$bookingChannelCodesBookingChannelCodeItem instanceof \StructType\BookingChannelCode) {
                $invalidValues[] = is_object($bookingChannelCodesBookingChannelCodeItem) ? get_class($bookingChannelCodesBookingChannelCodeItem) : sprintf('%s(%s)', gettype($bookingChannelCodesBookingChannelCodeItem), var_export($bookingChannelCodesBookingChannelCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingChannelCode property can only contain items of type \StructType\BookingChannelCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingChannelCode value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingChannelCode[] $bookingChannelCode
     * @return \StructType\BookingChannelCodes
     */
    public function setBookingChannelCode(array $bookingChannelCode = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingChannelCodeArrayErrorMessage = self::validateBookingChannelCodeForArrayConstraintsFromSetBookingChannelCode($bookingChannelCode))) {
            throw new \InvalidArgumentException($bookingChannelCodeArrayErrorMessage, __LINE__);
        }
        $this->BookingChannelCode = $bookingChannelCode;
        return $this;
    }
    /**
     * Add item to BookingChannelCode value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingChannelCode $item
     * @return \StructType\BookingChannelCodes
     */
    public function addToBookingChannelCode(\StructType\BookingChannelCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingChannelCode) {
            throw new \InvalidArgumentException(sprintf('The BookingChannelCode property can only contain items of type \StructType\BookingChannelCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingChannelCode[] = $item;
        return $this;
    }
    /**
     * Get ChannelCodesInclusive value
     * @return bool|null
     */
    public function getChannelCodesInclusive()
    {
        return $this->ChannelCodesInclusive;
    }
    /**
     * Set ChannelCodesInclusive value
     * @param bool $channelCodesInclusive
     * @return \StructType\BookingChannelCodes
     */
    public function setChannelCodesInclusive($channelCodesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($channelCodesInclusive) && !is_bool($channelCodesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($channelCodesInclusive, true), gettype($channelCodesInclusive)), __LINE__);
        }
        $this->ChannelCodesInclusive = $channelCodesInclusive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingChannelCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
